/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.core.internal.commons.LoggerLevel;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.Hint;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.component.ProcessorSync;
import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicObject;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicValue;
import javax.script.ScriptException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleComponent(value="Logger")
@ComponentOutput(attributes={ComponentOutput.PreviousComponent.class}, payload={ComponentOutput.PreviousComponent.class})
@ComponentInput(payload={Object.class}, description="Any payload to be logged")
@Description(value="This component allows to log information within a flow such as message payload, attributes, context variables and so on. A logger component can be added anywhere in a flow and it can log a simple text value or a dynamic expression. The Log Message input field type can be toggled to enter a static or dynamic expression value.")
@Component(service={LoggerComponent.class}, scope=ServiceScope.PROTOTYPE)
public class LoggerComponent
implements ProcessorSync {
    public static final Logger logger = LoggerFactory.getLogger(LoggerComponent.class);
    @Property(value="Logger Level")
    @Example(value="DEBUG")
    @InitValue(value="INFO")
    @DefaultValue(value="INFO")
    @Description(value="The logger level used to log the given message. Log levels can be configured from the <i>{RUNTIME_HOME}/config/logback.xml</i> file.")
    private LoggerLevel level;
    @Property(value="Log message")
    @Hint(value="my log message")
    @InitValue(value="#[message]")
    @DefaultValue(value="<code>message</code>")
    @Example(value="<code>'Attributes:' + message.attributes()</code>")
    @Description(value="Sets the message to be logged. It can be a static or dynamic value.")
    private DynamicObject message;
    @Reference
    private ScriptEngineService service;

    public Message apply(FlowContext flowContext, Message message) {
        try {
            if (LoggerLevel.DEBUG.equals(this.level)) {
                if (logger.isDebugEnabled()) {
                    this.debug(message, flowContext);
                }
            } else {
                this.debug(message, flowContext);
            }
        }
        catch (ScriptException exception) {
            throw new PlatformException((Throwable)exception);
        }
        return message;
    }

    public void setLevel(LoggerLevel level) {
        this.level = level;
    }

    public void setMessage(DynamicObject message) {
        this.message = message;
    }

    private void debug(Message message, FlowContext flowContext) throws ScriptException {
        Object evaluationResult = this.service.evaluate((DynamicValue)this.message, flowContext, message).orElse(null);
        this.level.log(logger, evaluationResult);
    }
}

