/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.core.internal.type.ListOfMessages;
import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.annotation.ScriptSignature;
import de.codecentric.reedelk.runtime.api.commons.AttributesUtils;
import de.codecentric.reedelk.runtime.api.component.Join;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.script.Script;
import de.codecentric.reedelk.runtime.api.script.ScriptEngineService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="Join With Script")
@ComponentInput(payload={Message[].class}, description="The messages to join using the given script")
@ComponentOutput(attributes={ComponentOutput.PreviousComponent.class}, payload={Object.class}, description="The joined content of the input messages payloads using by evaluating the given script.")
@Description(value="Can only be placed after a Fork. It joins the payloads of the messages resulting from the execution of the Fork with the provided script function. The mime type property specifies the mime type of the joined payloads. If the result of the script is null, an empty message payload content is set.")
@Component(service={JoinWithScript.class}, scope=ServiceScope.PROTOTYPE)
public class JoinWithScript
implements Join {
    @Property(value="Mime type")
    @MimeTypeCombo
    @DefaultValue(value="text/plain")
    @Example(value="application/json")
    @Description(value="Sets the mime type of the joined content in the message.")
    private String mimeType;
    @Property(value="Script")
    @Example(value="joiners/joinByType.groovy")
    @ScriptSignature(arguments={"context", "messages"}, types={FlowContext.class, ListOfMessages.class})
    @Description(value="The path of the script function to be invoked when executing the component")
    private Script script;
    @Reference
    private ScriptEngineService service;

    public Message apply(FlowContext flowContext, List<Message> messagesToJoin) {
        MessageAttributes mergedAttributes = AttributesUtils.merge(messagesToJoin);
        return this.service.evaluate(this.script, Object.class, new Object[]{flowContext, messagesToJoin}).map(result -> {
            MimeType parsedMimeType = MimeType.parse((String)this.mimeType, (MimeType)MimeType.TEXT_PLAIN);
            return MessageBuilder.get(JoinWithScript.class).withJavaObject(result, parsedMimeType).attributes(mergedAttributes).build();
        }).orElseGet(() -> MessageBuilder.get(JoinWithScript.class).attributes(mergedAttributes).empty().build());
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

