/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.core.component;

import de.codecentric.reedelk.runtime.api.annotation.ComponentInput;
import de.codecentric.reedelk.runtime.api.annotation.ComponentOutput;
import de.codecentric.reedelk.runtime.api.annotation.DefaultValue;
import de.codecentric.reedelk.runtime.api.annotation.Description;
import de.codecentric.reedelk.runtime.api.annotation.Example;
import de.codecentric.reedelk.runtime.api.annotation.InitValue;
import de.codecentric.reedelk.runtime.api.annotation.MimeTypeCombo;
import de.codecentric.reedelk.runtime.api.annotation.ModuleComponent;
import de.codecentric.reedelk.runtime.api.annotation.Property;
import de.codecentric.reedelk.runtime.api.commons.AttributesUtils;
import de.codecentric.reedelk.runtime.api.component.Join;
import de.codecentric.reedelk.runtime.api.converter.ConverterService;
import de.codecentric.reedelk.runtime.api.flow.FlowContext;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageBuilder;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@ModuleComponent(value="Join With Delimiter")
@ComponentInput(payload={Message[].class}, description="The messages to join using the given delimiter")
@ComponentOutput(attributes={ComponentOutput.PreviousComponent.class}, payload={String.class}, description="The joined content of the input messages payloads using the delimiter as separator. If a message does not have a payload of type string, it is converted to string before joining.")
@Description(value="Can only be placed after a Fork. It joins the payloads of the messages resulting from the execution of the Fork with the provided delimiter. A delimiter can be a single character or any other string. The mime type property specifies the mime type of the joined payloads. This component automatically converts the payload of each single input message to string in case they are not a string type already.")
@Component(service={JoinWithDelimiter.class}, scope=ServiceScope.PROTOTYPE)
public class JoinWithDelimiter
implements Join {
    @Property(value="Mime type")
    @MimeTypeCombo
    @DefaultValue(value="text/plain")
    @Example(value="application/json")
    @Description(value="Sets the mime type of the joined content in the message.")
    private String mimeType;
    @Property(value="Delimiter")
    @Example(value=";")
    @InitValue(value=",")
    @Description(value="The delimiter char (or string) to be used to join the content of the messages.")
    private String delimiter;
    @Reference
    private ConverterService converterService;

    public Message apply(FlowContext flowContext, List<Message> messagesToJoin) {
        String combinedPayload = messagesToJoin.stream().map(message -> {
            Object messageData = message.payload();
            return (String)this.converterService.convert(messageData, String.class);
        }).collect(Collectors.joining(this.delimiter));
        MimeType parsedMimeType = MimeType.parse((String)this.mimeType, (MimeType)MimeType.TEXT_PLAIN);
        MessageAttributes mergedAttributes = AttributesUtils.merge(messagesToJoin);
        return MessageBuilder.get(JoinWithDelimiter.class).withString(combinedPayload, parsedMimeType).attributes(mergedAttributes).build();
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

