/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.starter.api;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="run-once")
public class RunOnceSource
extends Source<Number, Void> {
    private static final Logger logger = LoggerFactory.getLogger(RunOnceSource.class);
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private SchedulerConfig schedulerConfig;
    private ComponentLocation location;
    private Scheduler scheduler;
    @Parameter
    @Optional(defaultValue="1")
    private long initialDelayTime;
    @Parameter
    @Optional(defaultValue="SECONDS")
    private TimeUnit initialDelayTimeUnit;
    @Parameter
    @Optional(defaultValue="1")
    private long delayBetweenTries;
    @Parameter
    @Optional(defaultValue="SECONDS")
    private TimeUnit delayBetweenTriesUnit;
    @Parameter
    @Optional(defaultValue="1")
    private int numberOfTries;
    private int currentTry;
    private SourceCallback<Number, Void> sourceCallback;

    public void onStart(SourceCallback<Number, Void> callback) {
        this.sourceCallback = callback;
        this.scheduler = this.schedulerService.customScheduler(this.schedulerConfig.withMaxConcurrentTasks(1).withName("start-once-scheduler " + this.location.getRootContainerName()).withWaitAllowed(true).withShutdownTimeout(5L, TimeUnit.SECONDS));
        this.scheduler.schedule((Callable)new StarterTask(), this.initialDelayTime, this.initialDelayTimeUnit);
    }

    public void onStop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    @OnSuccess
    public void onSuccess() {
        logger.error("run once succeded");
        this.scheduler.stop();
    }

    @OnError
    public void onError(Error error) {
        logger.error("run once, try {} of {} failed: {}", new Object[]{this.currentTry, this.numberOfTries, error.getDescription()});
        if (this.currentTry < this.numberOfTries) {
            this.scheduler.schedule((Callable)new StarterTask(), this.delayBetweenTries, this.delayBetweenTriesUnit);
        } else {
            this.scheduler.stop();
        }
    }

    private class StarterTask
    implements Callable<Void> {
        private StarterTask() {
        }

        @Override
        public Void call() {
            Result result = Result.builder().output((Object)(++RunOnceSource.this.currentTry)).build();
            RunOnceSource.this.sourceCallback.handle(result);
            return null;
        }
    }
}

