/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.limiter.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;

public class WaitTimeStorage {
    private Map<String, WaitEntry> id2timeMap = new HashMap<String, WaitEntry>();
    private SortedMap<Long, Map<String, WaitEntry>> waitTime2EntryMap = new TreeMap<Long, Map<String, WaitEntry>>();

    public synchronized void storeWaitTime(String id, long millisSinceEpoch) {
        Map.Entry<Long, Map<String, WaitEntry>> e;
        WaitEntry oldEntry = this.id2timeMap.get(id);
        if (oldEntry != null) {
            ((Map)this.waitTime2EntryMap.get(oldEntry.millisSinceEpoch)).remove(id);
        }
        WaitEntry entry = new WaitEntry(id, millisSinceEpoch);
        this.id2timeMap.put(id, entry);
        HashMap<String, WaitEntry> map = (HashMap<String, WaitEntry>)this.waitTime2EntryMap.get(millisSinceEpoch);
        if (map == null) {
            map = new HashMap<String, WaitEntry>();
            this.waitTime2EntryMap.put(millisSinceEpoch, map);
        }
        map.put(id, entry);
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<Long, Map<String, WaitEntry>>> iterator = this.waitTime2EntryMap.entrySet().iterator();
        while (iterator.hasNext() && (e = iterator.next()).getKey() <= now) {
            iterator.remove();
            for (String id2remove : e.getValue().keySet()) {
                this.id2timeMap.remove(id2remove);
            }
        }
    }

    public synchronized void removeWaitTime(String id) {
        WaitEntry oldEntry = this.id2timeMap.remove(id);
        if (oldEntry != null) {
            Map entryMapForTime = (Map)this.waitTime2EntryMap.get(oldEntry.millisSinceEpoch);
            entryMapForTime.remove(oldEntry.id);
            if (entryMapForTime.isEmpty()) {
                this.waitTime2EntryMap.remove(oldEntry.millisSinceEpoch);
            }
        }
    }

    public synchronized Optional<Long> retrieveWaitTime(String id) {
        WaitEntry waitEntry = this.id2timeMap.get(id);
        if (waitEntry != null) {
            long waitUntil = waitEntry.millisSinceEpoch;
            if (waitUntil < System.currentTimeMillis()) {
                this.removeWaitTime(id);
                return Optional.empty();
            }
            return Optional.of(waitUntil);
        }
        return Optional.empty();
    }

    private static class WaitEntry {
        final String id;
        final long millisSinceEpoch;

        public WaitEntry(String id, long millisSinceEpoch) {
            this.id = id;
            this.millisSinceEpoch = millisSinceEpoch;
        }
    }
}

