/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.limiter.internal;

import de.codecentric.limiter.internal.ExecuteErrorProvider;
import de.codecentric.limiter.internal.RatelimiterConfiguration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatelimiterOperations
implements Stoppable,
Startable {
    private static Logger logger = LoggerFactory.getLogger(RatelimiterOperations.class);
    @Inject
    private SchedulerService schedulerService;
    private ScheduledExecutorService scheduledExecutor;

    @Throws(value={ExecuteErrorProvider.class})
    public void limitRate(@Config RatelimiterConfiguration configuration, CompletionCallback<Void, Void> callback) {
        logger.debug("schedule command");
        configuration.schedule(this.scheduledExecutor, () -> {
            logger.debug("execute command");
            callback.success(Result.builder().build());
        });
    }

    public void fixedDelay(long delay, TimeUnit unit, CompletionCallback<Void, Void> callback) {
        logger.debug("delay: " + delay + ", unit: " + (Object)((Object)unit));
        this.scheduledExecutor.schedule(() -> {
            logger.debug("execute delayed command");
            callback.success(Result.builder().build());
        }, delay, unit);
    }

    public void start() {
        SchedulerConfig config = SchedulerConfig.config().withMaxConcurrentTasks(10).withShutdownTimeout(1L, TimeUnit.SECONDS).withPrefix("rate-limit").withName("operations");
        this.scheduledExecutor = this.schedulerService.customScheduler(config);
    }

    public void stop() {
        this.scheduledExecutor.shutdown();
    }
}

