/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.limiter.internal;

import de.codecentric.limiter.api.BufferOps;
import de.codecentric.limiter.api.CommandQueue;
import de.codecentric.limiter.internal.RatelimiterOperations;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@Configuration(name="rate-limiter")
@Operations(value={RatelimiterOperations.class})
public class RatelimiterConfiguration
implements Initialisable {
    @Parameter
    private long minTimeBetweenOperations;
    @Parameter
    private TimeUnit unit;
    @Parameter
    @DisplayName(value="Buffer type")
    private BufferOps bufferOps;
    private static final long NEVER = -1L;
    private volatile CommandQueue queue;
    private final Object lock = new Object();
    private final AtomicLong lastRun = new AtomicLong(-1L);

    public void initialise() throws InitialisationException {
        this.queue = new CommandQueue(this.bufferOps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(ScheduledExecutorService scheduledExecutor, Runnable command) {
        long minTimeBetweenOperationsInMillis = this.unit.toMillis(this.minTimeBetweenOperations);
        Object object = this.lock;
        synchronized (object) {
            boolean queueWasEmpty = this.queue.isEmpty();
            this.queue.push(command);
            if (queueWasEmpty) {
                long now = System.currentTimeMillis();
                long lr = this.lastRun.get();
                if (lr == -1L || now >= lr + minTimeBetweenOperationsInMillis) {
                    scheduledExecutor.schedule(new Runner(scheduledExecutor), 0L, TimeUnit.MILLISECONDS);
                } else {
                    scheduledExecutor.schedule(new Runner(scheduledExecutor), lr + minTimeBetweenOperationsInMillis - now, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private class Runner
    implements Runnable {
        ScheduledExecutorService scheduledExecutor;

        public Runner(ScheduledExecutorService scheduledExecutor) {
            this.scheduledExecutor = scheduledExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RatelimiterConfiguration.this.lastRun.set(System.currentTimeMillis());
            long minTimeBetweenOperationsInMillis = RatelimiterConfiguration.this.unit.toMillis(RatelimiterConfiguration.this.minTimeBetweenOperations);
            Optional<Runnable> command = RatelimiterConfiguration.this.queue.pop();
            try {
                command.ifPresent(Runnable::run);
            }
            finally {
                Object object = RatelimiterConfiguration.this.lock;
                synchronized (object) {
                    if (!RatelimiterConfiguration.this.queue.isEmpty()) {
                        this.scheduledExecutor.schedule(this, minTimeBetweenOperationsInMillis, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }
}

