/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.dwcaller.utils;

import de.codecentric.dwcaller.utils.PathBasedResourceResolver;
import de.codecentric.dwcaller.utils.SimpleLoggingService;
import de.codecentric.dwcaller.utils.WeavePathProtocolHandler;
import de.codecentric.dwcaller.utils.WeaveRunner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.mule.weave.v2.core.io.service.CustomWorkingDirectoryService;
import org.mule.weave.v2.core.io.service.WorkingDirectoryService;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.service.CharsetProviderService;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.model.service.ProtocolUrlSourceProviderResolverService;
import org.mule.weave.v2.model.service.UrlSourceProviderResolverService;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.InputType;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.ParserConfiguration;
import org.mule.weave.v2.runtime.ScriptingBindings;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Function0;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.Map;
import scala.collection.mutable.MutableList;

public class WeaveRunnerBuilder {
    private DataWeaveScriptingEngine scriptingEngine;
    private ServiceManager serviceManager;
    private List<Pattern> ignorePatterns = new ArrayList<Pattern>();
    private List<File> pathElements = new ArrayList<File>();
    private boolean addClassPath;

    public WeaveRunnerBuilder withIgnorePattern(Pattern pattern) {
        this.ignorePatterns.add(pattern);
        return this;
    }

    public WeaveRunnerBuilder withPathDir(File dir) {
        this.pathElements.add(dir);
        return this;
    }

    public WeaveRunnerBuilder withClassPath() {
        this.addClassPath = true;
        return this;
    }

    public WeaveRunner build() {
        if (this.addClassPath) {
            this.addJarsToClassPath();
        }
        PathBasedResourceResolver resourceResolver = new PathBasedResourceResolver(this.pathElements);
        SimpleModuleComponentFactory moduleComponentFactory = SimpleModuleComponentFactory.apply((WeaveResourceResolver)resourceResolver);
        this.scriptingEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)moduleComponentFactory, ParserConfiguration.apply((Seq)new MutableList(), (Seq)new MutableList()));
        SimpleLoggingService logger = new SimpleLoggingService();
        for (Pattern p : this.ignorePatterns) {
            logger.addIgnorePattern(p);
        }
        this.serviceManager = this.createServiceManager(logger, resourceResolver);
        return new WeaveRunnerImplementation(this.scriptingEngine, this.serviceManager);
    }

    private void addJarsToClassPath() {
        String classPath = System.getProperty("java.class.path");
        String pathSep = System.getProperty("path.separator");
        StringTokenizer tok = new StringTokenizer(classPath, pathSep);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            this.pathElements.add(new File(s));
        }
    }

    private ServiceManager createServiceManager(LoggingService logger, PathBasedResourceResolver pathBasedResourceResolver) {
        Function0<File> directoryFunction = new Function0<File>(){

            public File apply() {
                File dwHome = new File(new File(System.getProperty("user.home")), ".dw");
                File tmpDirectory = new File(dwHome, "tmp");
                if (!tmpDirectory.exists()) {
                    tmpDirectory.mkdirs();
                }
                return tmpDirectory;
            }
        };
        HashMap customServices = new HashMap();
        MutableList handlers = new MutableList();
        handlers.appendElem((Object)new WeavePathProtocolHandler(pathBasedResourceResolver));
        ProtocolUrlSourceProviderResolverService service = new ProtocolUrlSourceProviderResolverService((Seq)handlers);
        customServices.$plus(new Tuple2(UrlSourceProviderResolverService.class, (Object)service));
        customServices.$plus(new Tuple2(WorkingDirectoryService.class, (Object)new CustomWorkingDirectoryService((Function0)directoryFunction, true)));
        customServices.$plus(new Tuple2(CharsetProviderService.class, (Object)this.createCharsetProvider()));
        return ServiceManager.apply((LoggingService)logger, (Map)customServices);
    }

    private CharsetProviderService createCharsetProvider() {
        return new CharsetProviderService(){

            public Charset defaultCharset() {
                return StandardCharsets.UTF_8;
            }
        };
    }

    private static class WeaveRunnerImplementation
    implements WeaveRunner {
        private DataWeaveScriptingEngine scriptingEngine;
        private ServiceManager serviceManager;

        WeaveRunnerImplementation(DataWeaveScriptingEngine scriptingEngine, ServiceManager serviceManager) {
            this.scriptingEngine = scriptingEngine;
            this.serviceManager = serviceManager;
        }

        @Override
        public DataWeaveScriptingEngine getScriptingEngine() {
            return this.scriptingEngine;
        }

        @Override
        public ServiceManager getServiceManager() {
            return this.serviceManager;
        }

        @Override
        public DataWeaveScript compile(File script, ScriptingBindings bindings) {
            InputType[] inputs = this.bindingsToInputs(bindings);
            return this.scriptingEngine.compile(script, inputs);
        }

        private InputType[] bindingsToInputs(ScriptingBindings bindings) {
            ArrayList<InputType> inputs = new ArrayList<InputType>();
            Iterator iter = bindings.entries().iterator();
            while (iter.hasNext()) {
                inputs.add(new InputType((String)iter.next(), Option.empty()));
            }
            return inputs.toArray(new InputType[inputs.size()]);
        }

        @Override
        public DataWeaveResult runScript(DataWeaveScript script, ScriptingBindings bindings, String defaultOutputMimeType) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            return this.runScript(script, bindings, defaultOutputMimeType, bos);
        }

        @Override
        public DataWeaveResult runScript(DataWeaveScript script, ScriptingBindings bindings, String defaultOutputMimeType, OutputStream bos) {
            Option out = Option.apply((Object)bos);
            return script.write(bindings, this.serviceManager, "application/java", out);
        }
    }
}

