/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.dwcaller.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SynchronizeUtil {
    private Set<File> nodesExpectedInDest = new HashSet<File>();
    private Set<Pattern> doNotDeletePatterns = new HashSet<Pattern>();
    private boolean changesDetected = false;

    public void addToExpected(File node) {
        this.nodesExpectedInDest.add(SynchronizeUtil.absoluteCanonical(node));
    }

    public void addToDoNotDeletePatterns(Pattern pattern) {
        this.doNotDeletePatterns.add(pattern);
    }

    public void syncFileOrDirectory(File sourceNode, File destNode) throws IOException {
        if (sourceNode.isDirectory()) {
            this.syncDirectory(sourceNode, destNode);
        } else if (sourceNode.isFile()) {
            this.syncFile(sourceNode, destNode);
        }
    }

    public void deleteUnexpectedNodes(File destination) throws IOException {
        if (destination.isDirectory()) {
            this.deleteUnexpectedDirectory(destination);
        } else if (destination.isFile()) {
            this.deleteUnexpectedFile(destination);
        } else {
            throw new IOException("Don't know how to handle " + destination);
        }
    }

    private void deleteUnexpectedFile(File file) throws IOException {
        if (!this.nodesExpectedInDest.contains(file.getAbsoluteFile().getCanonicalFile())) {
            for (Pattern p : this.doNotDeletePatterns) {
                if (!p.matcher(file.getName()).matches()) continue;
                return;
            }
            if (!file.delete()) {
                throw new IOException("Could not delete " + file);
            }
        }
    }

    private void deleteUnexpectedDirectory(File dir) throws IOException {
        for (File node : dir.listFiles()) {
            this.deleteUnexpectedNodes(node);
        }
        if (!this.nodesExpectedInDest.contains(dir.getAbsoluteFile().getCanonicalFile()) && dir.list().length == 0 && !dir.delete()) {
            throw new IOException("Could not delete " + dir);
        }
    }

    public boolean haveDectectedChanges() {
        return this.changesDetected;
    }

    private void syncDirectory(File sourceDir, File destDir) throws IOException {
        if (destDir.isFile()) {
            SynchronizeUtil.deleteFileOrDirectory(destDir);
            this.changesDetected = true;
        }
        if (!destDir.isDirectory()) {
            if (!destDir.mkdir()) {
                throw new IOException("Could not create directory " + destDir);
            }
            this.changesDetected = true;
        }
        for (File sourceNode : sourceDir.listFiles()) {
            String name = sourceNode.getName();
            File destNode = new File(destDir, name);
            this.syncFileOrDirectory(sourceNode, destNode);
        }
        this.addToExpected(destDir);
    }

    private void syncFile(File source, File dest) throws IOException {
        if (SynchronizeUtil.haveToCopy(source, dest)) {
            SynchronizeUtil.copyFile(source, dest);
            this.changesDetected = true;
        }
        this.addToExpected(dest);
    }

    private static void copyFile(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream source = new FileInputStream(sourceFile);
             FileOutputStream target = new FileOutputStream(targetFile);){
            int read;
            byte[] buffer = new byte[65536];
            do {
                if ((read = ((InputStream)source).read(buffer)) <= 0) continue;
                ((OutputStream)target).write(buffer, 0, read);
            } while (read > 0);
        }
    }

    private static void deleteFileOrDirectory(File node) throws IOException {
        if (node.isFile()) {
            Files.delete(node.toPath());
        } else if (node.isDirectory()) {
            for (File subNode : node.listFiles()) {
                SynchronizeUtil.deleteFileOrDirectory(subNode);
            }
        } else {
            throw new IOException("Don't know how to delete " + node);
        }
    }

    private static boolean haveToCopy(File source, File dest) throws IOException {
        if (dest.exists()) {
            boolean haveTo;
            if (dest.isDirectory()) {
                SynchronizeUtil.deleteFileOrDirectory(dest);
                return true;
            }
            if (!dest.isFile()) {
                throw new IOException("Don't know what to do with " + dest + " at target position");
            }
            boolean bl = haveTo = source.lastModified() > dest.lastModified() || source.length() != dest.length();
            if (haveTo) {
                SynchronizeUtil.deleteFileOrDirectory(dest);
            }
            return haveTo;
        }
        return true;
    }

    private static File absoluteCanonical(File file) {
        file = file.getAbsoluteFile();
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }
}

