/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.dwcaller.utils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.mule.weave.v2.model.service.LoggingService;

public class SimpleLoggingService
implements LoggingService {
    private PrintStream out;
    private List<Pattern> ignorePatterns;

    public SimpleLoggingService(PrintStream destination) {
        this.out = destination;
        this.ignorePatterns = new ArrayList<Pattern>();
    }

    public SimpleLoggingService() {
        this(System.out);
    }

    public void addIgnorePattern(Pattern pattern) {
        this.ignorePatterns.add(pattern);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void logError(String msg) {
        this.log(msg);
    }

    public void logInfo(String msg) {
        this.log(msg);
    }

    public void logWarn(String msg) {
        this.log(msg);
    }

    private void log(String msg) {
        for (Pattern p : this.ignorePatterns) {
            if (!p.matcher(msg).matches()) continue;
            return;
        }
        this.out.println(msg);
    }
}

