/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.dwcaller.test;

import de.codecentric.dwcaller.test.Location;
import de.codecentric.dwcaller.test.TestStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TestResult {
    private String name = "";
    private int time;
    private TestStatus status;
    private String errorMessage;
    private String text;
    private String sourceIdentifier = "";
    private Location start;
    private Location end;
    private List<TestResult> tests = new ArrayList<TestResult>();

    public TestResult() {
        this.start = Location.UNKNOWN;
        this.end = Location.UNKNOWN;
    }

    public TestResult(String name) {
        this();
        this.name = name;
    }

    public TestResult(String name, TestStatus status, String errorMessage) {
        this(name);
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public TestResult(Map<String, Object> data) {
        this();
        List testList;
        this.name = (String)data.get("name");
        this.time = (Integer)data.get("time");
        this.status = TestStatus.valueOf((String)data.get("status"));
        this.errorMessage = (String)data.get("errorMessage");
        this.text = (String)data.get("text");
        Map locationObject = (Map)data.get("location");
        if (locationObject != null) {
            this.start = new Location((Map)locationObject.get("start"));
            this.end = new Location((Map)locationObject.get("end"));
            this.sourceIdentifier = (String)locationObject.get("sourceIdentifier");
        }
        if ((testList = (List)data.get("tests")) != null) {
            for (Map testObject : testList) {
                this.tests.add(new TestResult(testObject));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getTime() {
        return this.time;
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getText() {
        return this.text;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public Location getStart() {
        return this.start;
    }

    public Location getEnd() {
        return this.end;
    }

    public List<TestResult> getTests() {
        return this.tests;
    }

    public void addTest(TestResult test) {
        this.tests.add(test);
    }

    public boolean isLeave() {
        return this.tests.isEmpty();
    }

    public boolean isAllSuccess() {
        if (this.isLeave()) {
            return this.status.isSuccess();
        }
        boolean success = true;
        for (TestResult t : this.tests) {
            success &= t.isAllSuccess();
        }
        return success;
    }
}

