/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.dwcaller.test;

import de.codecentric.dwcaller.TestRunner;
import de.codecentric.dwcaller.test.TestResult;
import de.codecentric.dwcaller.test.TestStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.Executable;

public abstract class DataWeaveTests {
    protected Collection<DynamicNode> some(String ... names) throws IOException {
        TestResult result = this.simplifyTree(TestRunner.run(names));
        ArrayList<DynamicNode> tests = new ArrayList<DynamicNode>();
        this.addTests(tests, result);
        return tests;
    }

    protected Collection<DynamicNode> all() throws IOException {
        return this.some(new String[0]);
    }

    private TestResult simplifyTree(TestResult tree) {
        if (!tree.isLeave() && tree.getTests().size() == 1) {
            return this.simplifyTree(tree.getTests().get(0));
        }
        return tree;
    }

    private void addTests(List<DynamicNode> tests, final TestResult result) {
        if (result.isLeave()) {
            switch (result.getStatus()) {
                case OK: 
                case SKIP: {
                    String name = result.getName();
                    if (result.getStatus() == TestStatus.SKIP) {
                        name = name + " SKIP";
                    }
                    tests.add((DynamicNode)DynamicTest.dynamicTest((String)name, (Executable)new Executable(){

                        public void execute() {
                        }
                    }));
                    break;
                }
                case ERROR: 
                case FAIL: {
                    tests.add((DynamicNode)DynamicTest.dynamicTest((String)result.getName(), (Executable)new Executable(){

                        public void execute() throws Throwable {
                            Throwable e = new Throwable(result.getErrorMessage());
                            StackTraceElement[] trace = new StackTraceElement[]{new StackTraceElement(this.className(result.getSourceIdentifier()), result.getName(), result.getSourceIdentifier(), result.getStart().getLine())};
                            e.setStackTrace(trace);
                            throw e;
                        }

                        private String className(String name) {
                            int start = name.lastIndexOf("::");
                            return start == -1 ? name : name.substring(start + 2);
                        }
                    }));
                    break;
                }
                default: {
                    Assertions.fail((String)("unknown status: " + (Object)((Object)result.getStatus())));
                    break;
                }
            }
        } else {
            ArrayList<DynamicNode> nodes = new ArrayList<DynamicNode>();
            for (TestResult test : result.getTests()) {
                this.addTests(nodes, test);
            }
            tests.add((DynamicNode)DynamicContainer.dynamicContainer((String)result.getName(), nodes));
        }
    }
}

