/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.dwcaller;

import de.codecentric.dwcaller.test.TestResult;
import de.codecentric.dwcaller.test.TestStatus;
import de.codecentric.dwcaller.test.TextReporter;
import de.codecentric.dwcaller.utils.SynchronizeUtil;
import de.codecentric.dwcaller.utils.WeaveRunner;
import de.codecentric.dwcaller.utils.WeaveRunnerBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.mule.weave.v2.runtime.BindingValue;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class TestRunner {
    private String[] args;

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        TestResult result = TestRunner.run(args);
        System.out.print(TextReporter.test2report(result));
        long finish = System.currentTimeMillis();
        System.out.println("Time needed: " + (finish - start) + "ms");
        System.exit(result.isAllSuccess() ? 0 : 1);
    }

    public static TestResult run(String[] args) throws IOException {
        File srcMainResources = new File("src/main/resources");
        File srcTestResources = new File("src/test/resources");
        File srcTestDw = new File("src/test/dw");
        File targetClasses = new File("target/classes");
        File targetTestClasses = new File("target/test-classes");
        String dwtestResources = System.getProperty("dwtestResources");
        if (dwtestResources == null) {
            System.setProperty("dwtestResources", srcTestResources.getAbsolutePath());
        }
        SynchronizeUtil syncher = new SynchronizeUtil();
        syncher.addToDoNotDeletePatterns(Pattern.compile(".*\\.class"));
        syncher.addToDoNotDeletePatterns(Pattern.compile(".*\\.xml"));
        syncher.addToDoNotDeletePatterns(Pattern.compile(".*\\.dwl"));
        syncher.syncFileOrDirectory(srcMainResources, targetClasses);
        syncher.syncFileOrDirectory(srcTestResources, targetTestClasses);
        syncher.syncFileOrDirectory(srcTestDw, targetTestClasses);
        syncher.deleteUnexpectedNodes(targetTestClasses);
        syncher.deleteUnexpectedNodes(targetClasses);
        TestRunner runner = new TestRunner(args);
        TestResult result = runner.runTests();
        return result;
    }

    private TestResult runTests() {
        TestResult result;
        WeaveRunner weaveRunner = new WeaveRunnerBuilder().withIgnorePattern(Pattern.compile("data-weave-testing-framework.*", 32)).withPathDir(new File("src/main/resources")).withPathDir(new File("src/test/resources")).withClassPath().build();
        if (this.args.length == 0) {
            File root = new File("src/test/");
            result = this.runTest(root, weaveRunner);
        } else if (this.args.length == 1) {
            result = this.runTest(new File(this.args[0]), weaveRunner);
        } else {
            result = new TestResult("all tests");
            for (String arg : this.args) {
                TestResult oneResult = this.runTest(new File(arg), weaveRunner);
                if (!this.isAddableResult(oneResult)) continue;
                result.addTest(oneResult);
            }
        }
        return result;
    }

    public TestRunner(String[] args) {
        this.args = args;
    }

    private TestResult runTest(File fileOrDirectory, WeaveRunner weaveRunner) {
        if (fileOrDirectory.isDirectory()) {
            return this.runTestsInDirectory(fileOrDirectory, weaveRunner);
        }
        if (fileOrDirectory.isFile()) {
            return this.runTestsInFile(fileOrDirectory, weaveRunner);
        }
        TestResult test = new TestResult(fileOrDirectory.getName(), TestStatus.ERROR, "Neither File nor directory: " + fileOrDirectory);
        return test;
    }

    private TestResult runTestsInDirectory(File fileOrDirectory, WeaveRunner weaveRunner) {
        File[] files;
        TestResult result = new TestResult(fileOrDirectory.getName());
        for (File f : files = fileOrDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".dwl");
            }
        })) {
            TestResult oneResult = this.runTest(f, weaveRunner);
            if (!this.isAddableResult(oneResult)) continue;
            result.addTest(oneResult);
        }
        return result;
    }

    private boolean isAddableResult(TestResult oneResult) {
        return oneResult != null && (oneResult.getStatus() != null || oneResult.getTests().size() > 0);
    }

    private TestResult runTestsInFile(File fileOrDirectory, WeaveRunner weaveRunner) {
        ScriptingBindings bindings = new ScriptingBindings();
        this.addPredefinedBindings(bindings);
        DataWeaveScript script = weaveRunner.compile(fileOrDirectory, bindings);
        DataWeaveResult result = weaveRunner.runScript(script, bindings, "application/java");
        Object content = result.getContent();
        return new TestResult((Map)content);
    }

    private void addPredefinedBindings(ScriptingBindings bindings) {
        String[] predefined;
        for (String p : predefined = new String[]{"app", "attributes", "authentication", "correlationId", "flow", "message", "mule", "payload", "server", "vars"}) {
            bindings.addBinding(p, BindingValue.apply(Collections.emptyMap(), (String)"application/java"));
        }
    }
}

