/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jmeter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="create-graph")
public class JMeterPluginsMojo
extends AbstractMojo {
    public static final String JMETER_CONFIG_ARTIFACT_NAME = "ApacheJMeter_config";
    public static final String JMETER_PLUGINS_ARTIFACT_NAME = "jmeter-plugins";
    public static final String JMETER_ARTIFACT_NAME = "ApacheJMeter";
    public static final String JMETER_CORE_ARTIFACT_NAME = "ApacheJMeter_core";
    @Parameter
    File inputFile;
    @Parameter
    List<Graph> graphs;
    @Parameter(defaultValue="${project.build.directory}/jmeter")
    File workingDirectory;
    @Component
    MavenProject mavenProject;
    @Component
    MavenSession mavenSession;
    @Component
    BuildPluginManager pluginManager;
    @Component
    PluginDescriptor plugin;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.graphs == null) {
            this.getLog().error((CharSequence)"No graphs defined.");
        }
        File binDir = new File(this.workingDirectory.getAbsolutePath() + File.separator + "bin");
        File logDir = new File(this.workingDirectory.getAbsolutePath() + File.separator + "log");
        File libDir = new File(this.workingDirectory.getAbsolutePath() + File.separator + "lib");
        File libExtDir = new File(libDir.getAbsolutePath() + File.separator + "ext");
        this.createDirectoryIfNotExists(this.workingDirectory);
        this.createDirectoryIfNotExists(binDir);
        this.createDirectoryIfNotExists(logDir);
        this.createDirectoryIfNotExists(libDir);
        this.createDirectoryIfNotExists(libExtDir);
        for (Artifact artifact : this.plugin.getArtifacts()) {
            try {
                File artifactDestination;
                if (JMETER_CONFIG_ARTIFACT_NAME.equals(artifact.getArtifactId())) {
                    this.getLog().debug((CharSequence)("Copy configuration files to " + binDir.getAbsolutePath()));
                    JarFile jarFile = new JarFile(artifact.getFile());
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().startsWith("bin") || !entry.getName().endsWith(".properties")) continue;
                        File configFileDestination = new File(this.workingDirectory + File.separator + entry.getName());
                        this.getLog().debug((CharSequence)("Write configuration " + configFileDestination.getAbsoluteFile()));
                        FileUtils.copyInputStreamToFile((InputStream)jarFile.getInputStream(entry), (File)configFileDestination);
                    }
                    jarFile.close();
                    continue;
                }
                if (this.isJMeterDependency(artifact)) {
                    this.getLog().debug((CharSequence)("Copy artifact " + artifact.toString() + " to " + libDir.getAbsolutePath()));
                    artifactDestination = new File(libDir.getAbsolutePath() + File.separator + artifact.getArtifactId() + ".jar");
                    FileUtils.copyFile((File)artifact.getFile(), (File)artifactDestination);
                    continue;
                }
                if (!this.isJMeterPluginsDependency(artifact)) continue;
                this.getLog().debug((CharSequence)("Copy artifact " + artifact.toString() + " to " + libExtDir.getAbsolutePath()));
                artifactDestination = new File(libExtDir.getAbsolutePath() + File.separator + artifact.getArtifactId() + ".jar");
                FileUtils.copyFile((File)artifact.getFile(), (File)artifactDestination);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy JMeter dependencies to working directory", (Exception)e);
            }
        }
        for (Graph graph : this.graphs) {
            this.getLog().debug((CharSequence)("Creating graph: " + this.graphs != null ? this.graphs.toString() : "<null>"));
            try {
                MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"exec-maven-plugin"), (String)MojoExecutor.version((String)"1.2.1")), (String)MojoExecutor.goal((String)"exec"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"executable"), (String)"java"), MojoExecutor.element((String)MojoExecutor.name((String)"workingDirectory"), (String)binDir.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"arguments"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"-Dlog_file="), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"-classpath"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)(libDir.getAbsolutePath() + File.separator + "*" + File.pathSeparator + libExtDir.getAbsolutePath() + File.separator + "*")), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"kg.apc.cmd.UniversalRunner"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--tool"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"Reporter"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--input-jtl"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)this.inputFile.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--plugin-type"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.pluginType), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--width"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.width)), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--height"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.height)), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--generate-png"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.outputFile.getAbsolutePath())})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    private boolean isJMeterPluginsDependency(Artifact artifact) {
        return this.isDependencyOf(artifact, JMETER_PLUGINS_ARTIFACT_NAME);
    }

    private boolean isJMeterDependency(Artifact artifact) {
        return this.isDependencyOf(artifact, JMETER_ARTIFACT_NAME) || this.isDependencyOf(artifact, JMETER_CORE_ARTIFACT_NAME);
    }

    private boolean isDependencyOf(Artifact artifact, String parentArtifactName) {
        for (String parent : artifact.getDependencyTrail()) {
            if (!parent.contains(parentArtifactName)) continue;
            return true;
        }
        return false;
    }

    private void createDirectoryIfNotExists(File directory) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Set up jmeter in " + directory));
        if (!directory.exists() && !directory.mkdirs()) {
            throw new MojoExecutionException("Could not make working directory: '" + directory.getAbsolutePath() + "'");
        }
    }

    public static class Graph {
        String pluginType;
        Integer width;
        Integer height;
        File outputFile;

        public String toString() {
            return "Graph{pluginType='" + this.pluginType + '\'' + ", width=" + this.width + ", height=" + this.height + ", outputFile=" + this.outputFile + '}';
        }
    }
}

