/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.logging.soapmsg;

import de.codecentric.cxf.logging.BaseLogger;
import java.util.logging.Logger;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.interceptor.LoggingOutInterceptor;

public class SoapMessageLoggingOutInterceptor
extends LoggingOutInterceptor {
    private static final BaseLogger LOG = BaseLogger.getLogger(SoapMessageLoggingOutInterceptor.class);
    private boolean doLogging = false;
    private boolean doExtraction = false;

    protected void log(Logger logger, String message) {
        if (this.doLogging) {
            super.log(logger, message);
        } else if (this.doExtraction) {
            // empty if block
        }
    }

    protected String formatLoggingMessage(LoggingMessage loggingMessage) {
        if (this.logButDontExtract()) {
            return this.buildLogStatementWithSoapMessage(loggingMessage);
        }
        if (this.extractButDontLog()) {
            return this.extractSoapMessageForElasticSearchProcessing(loggingMessage);
        }
        if (this.logAndExtract()) {
            this.extractSoapMessageForElasticSearchProcessing(loggingMessage);
            return this.buildLogStatementWithSoapMessage(loggingMessage);
        }
        return "";
    }

    private String extractSoapMessageForElasticSearchProcessing(LoggingMessage loggingMessage) {
        if (loggingMessage.getPayload().length() > 0) {
            LOG.logOutboundSoapMessage(loggingMessage.getPayload().toString().replaceAll("(?<=<dtypes:Data xmime:contentType=\"application/pdf\">)[^><]+(?=</dtypes:Data>)", "PdfFiltered"));
        }
        return "";
    }

    private String buildLogStatementWithSoapMessage(LoggingMessage loggingMessage) {
        StringBuilder buffer = new StringBuilder();
        if (loggingMessage.getPayload().length() > 0) {
            buffer.append("000 >>> Outbound Message:\n");
            buffer.append((CharSequence)loggingMessage.getPayload());
        }
        return buffer.toString();
    }

    private boolean logAndExtract() {
        return this.doLogging && this.doExtraction;
    }

    private boolean extractButDontLog() {
        return this.doExtraction && !this.doLogging;
    }

    private boolean logButDontExtract() {
        return this.doLogging && !this.doExtraction;
    }

    public void logSoapMessage(boolean active) {
        this.doLogging = active;
    }

    public void extractSoapMessage(boolean active) {
        this.doExtraction = active;
    }
}

