/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.configuration;

import de.codecentric.cxf.xmlvalidation.CustomFaultBuilder;
import de.codecentric.cxf.xmlvalidation.SoapFaultBuilder;
import de.codecentric.cxf.xmlvalidation.XmlValidationInterceptor;
import javax.xml.ws.Endpoint;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.jaxws.EndpointImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={CustomFaultBuilder.class})
@ConditionalOnProperty(name={"endpoint.autoinit"}, matchIfMissing=true)
public class XmlValidationConfiguration {
    @Autowired
    public Endpoint endpoint;

    @Bean
    public SoapFaultBuilder soapFaultBuilder() {
        return new SoapFaultBuilder();
    }

    @Bean
    public AbstractSoapInterceptor soapInterceptor() {
        XmlValidationInterceptor xmlValidationInterceptor = new XmlValidationInterceptor();
        xmlValidationInterceptor.setSoapFaultBuilder(this.soapFaultBuilder());
        EndpointImpl endpointImpl = (EndpointImpl)this.endpoint;
        endpointImpl.getOutFaultInterceptors().add(xmlValidationInterceptor);
        return xmlValidationInterceptor;
    }
}

