/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.logging;

import de.codecentric.cxf.common.FaultType;
import de.codecentric.cxf.logging.ElasticsearchField;
import net.logstash.logback.marker.Markers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class BaseLogger {
    private Logger delegateLogger;

    private BaseLogger() {
    }

    public static <L> BaseLogger getLogger(Class<L> class2LogFor) {
        BaseLogger frameworkLogger = new BaseLogger();
        frameworkLogger.delegateLogger = LoggerFactory.getLogger(class2LogFor);
        return frameworkLogger;
    }

    public void logInboundSoapMessage(String inboundSoapMessage) {
        this.log2Elasticsearch(ElasticsearchField.SOAP_MESSAGE_INBOUND, inboundSoapMessage, "===[> Inbound-SoapMessage ===[> stored in ElasticsearchField '{}'");
    }

    public void logOutboundSoapMessage(String outboundSoapMessage) {
        this.log2Elasticsearch(ElasticsearchField.SOAP_MESSAGE_OUTBOUND, outboundSoapMessage, "<]=== Outbound-SoapMessage <]=== stored in ElasticsearchField '{}'");
    }

    public void logHttpHeader(String headers) {
        this.log2Elasticsearch(ElasticsearchField.HTTP_HEADER_INBOUND, headers, "001 >>> Header in Inbound-HTTP-Message stored in Elasticsearch-Field '{}'");
    }

    public void successfullyCalledServeEndpointWithMethod(String calledServiceMethod) {
        this.logInfo("002", "The Serviceendpoint was called successfully with the Method '{}()' - handing over to internal processing.", calledServiceMethod);
    }

    public void logCallTime(String calltime) {
        this.logInfo("009", "Calltime: {}", calltime);
    }

    public <T> void facadeModeReturningDummyResponseWithResponseType(Class<T> responseType) {
        this.logDebug("501", "Facade-Mode: Returning Dummy-Response with ResponseType {}", responseType);
    }

    public void errorOccuredInBackendProcessing(Throwable cause) {
        this.logError("901", "An Error accured in backend-processing: {}", cause.getMessage());
    }

    public void failedToBuildServiceCompliantSoapFaultDetails(Throwable cause) {
        this.logError("902", "Failed to build service-compliant SoapFault-details: {}\nStacktrace: {}", cause.getMessage(), cause.getStackTrace());
    }

    public void schemaValidationError(FaultType error, String faultMessage) {
        this.logDebug("903", error.getMessage() + ": {}", faultMessage);
    }

    private void log2Elasticsearch(ElasticsearchField elasticsearchField, String elasticsearchFieldValue, String logTemplate) {
        this.delegateLogger.info((Marker)Markers.append((String)elasticsearchField.getName(), (Object)elasticsearchFieldValue), logTemplate, (Object)elasticsearchField.getName());
    }

    private String logDebugAndBuildExceptionMessage(String id, String messageTemplate, Object ... parameters) {
        this.logDebug(id, messageTemplate, parameters);
        return this.exceptionMessage(id, messageTemplate, parameters);
    }

    private void logDebug(String id, String messageTemplate, Object ... parameters) {
        String msg = this.formatMessage(id, messageTemplate);
        this.delegateLogger.debug(msg, parameters);
    }

    private void logInfo(String id, String messageTemplate, Object ... parameters) {
        String msg = this.formatMessage(id, messageTemplate);
        this.delegateLogger.info(msg, parameters);
    }

    private void logError(String id, String messageTemplate, Object ... parameters) {
        String msg = this.formatMessage(id, messageTemplate);
        this.delegateLogger.error(msg, parameters);
    }

    private String formatMessage(String id, String messageTemplate) {
        return id + " >>> " + messageTemplate;
    }

    private String exceptionMessage(String id, String messageTemplate, Object ... parameters) {
        String message = this.formatMessage(id, messageTemplate);
        if (parameters == null || parameters.length == 0) {
            return message;
        }
        return MessageFormatter.arrayFormat((String)message, (Object[])parameters).getMessage();
    }
}

