package de.codecentric.cxf.autodetection.diagnostics;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

/**
 * FailureAnalyzer to show custom Failure Message, if the cxf-spring-boot-maven.properties is missing
 * (which is generated by the https://github.com/codecentric/cxf-spring-boot-starter-maven-plugin &
 * is mandatory for autodetection and instantiation of the CXF endpoint(s)).
 *
 * @author jonashackt
 */
public class CxfSpringBootMavenPropertiesMissingFailureAnalyzer extends AbstractFailureAnalyzer<CxfSpringBootMavenPropertiesNotFoundException> {

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, CxfSpringBootMavenPropertiesNotFoundException cause) {
        return new FailureAnalysis(CxfSpringBootMavenPropertiesNotFoundException.MESSAGE,
                "Please check if you integrated https://github.com/codecentric/cxf-spring-boot-starter-maven-plugin properly into the build section" +
                        "of your pom.xml & ran a SUCCESSFUL 'mvn clean generate-sources'. This should generate the needed cxf-spring-boot-maven.properties," +
                        "which are needed for proper auto initialization of your Apache CXF endpoints!", cause);
    }

}
