/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf;

import com.sun.tools.xjc.api.XJC;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class BootCxfMojo
extends AbstractMojo {
    private static final String GENERATED_SOURCES_TARGET_FOLDER = "target/generated-sources/wsdlimport";
    private static final String TEST_GENERATED_SOURCES_TARGET_FOLDER = "target/test/generated-sources/wsdlimport";
    private static final String WSDL_NOT_FOUND_ERROR_MESSAGE = ".wsdl-File not found - is it placed somewhere under /src/main/resources or /src/test/resources?";
    private static final String LOG_PREFIX = "CXF-BOOT-MAVEN-PLUGIN ";
    public static final String CXF_SPRING_BOOT_MAVEN_PROPERTIES_FILE_NAME = "cxf-spring-boot-maven.properties";
    public static final String SEI_IMPLEMENTATION_PACKAGE_NAME_KEY = "sei.implementation.package.name";
    public static final String SEI_AND_WEB_SERVICE_CLIENT_PACKAGE_NAME_KEY = "sei.and.webserviceclient.package.name";
    private static final String REGEX_FIND_TARGET_NAMESPACE_CONTENT = "(?<=targetNamespace=\")[:._/a-zA-Z0-9-]+(?=\")";
    private static final String TARGET_NAMESPACE_COULDNT_BE_EXTRACTED = "targetNamespace could not be extracted from WSDL file.";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        this.logWithPrefix("STEP 0: Scanning for WSDL file in src/main/resources");
        File wsdl = this.findWsdl(this.mavenProject.getBasedir());
        String buildDirectory = this.mavenProject.getBuild().getOutputDirectory();
        this.logWithPrefix("STEP 1: Found .wsdl-File: " + wsdl.getPath());
        if (this.isWsdlLocatedInTestResources(wsdl)) {
            this.logWithPrefix("STEP 2: Generating JAX-B Classfiles for Test purpose.");
            this.generateJaxbClassFiles(wsdl, "wsimport-test", TEST_GENERATED_SOURCES_TARGET_FOLDER);
            this.logWithPrefix("STEP 3: Adding the generated Test-Java-Classes to project\u00b4s classpath...");
            this.addGeneratedTestClasses2Cp();
        } else if (this.isWsdlLocatedInMainResources(wsdl)) {
            this.logWithPrefix("STEP 2: Generating JAX-B Classfiles.");
            this.generateJaxbClassFiles(wsdl, "wsimport", GENERATED_SOURCES_TARGET_FOLDER);
            this.logWithPrefix("STEP 3: Adding the generated Java-Classes to project\u00b4s classpath...");
            this.addGeneratedClasses2Cp();
        }
        this.logWithPrefix("STEP 4: Guessing SEI implementation\u00b4s package name & injecting it into cxf-spring-boot-maven.properties for later Autodetection of Endpoints...");
        this.cleanCxfSpringBootMavenProperties(buildDirectory);
        this.writeSeiImplementationPackageToCxfSpringBootMavenPropterties(buildDirectory, this.mavenProject.getGroupId());
        this.logWithPrefix("STEP 5: Extracting targetNamespace from WSDL, generating packageName from it with com.sun.tools.xjc.api.XJC (see wsgen, WSImportTool and WSDLModeler at line 2312 of the JAXWSRI) and injecting it into cxf-spring-boot-maven.properties for later Autodetection of Endpoints...");
        String targetNamespaceFromWsdl = this.readTargetNamespaceFromWsdl(BootCxfMojo.readWsdlIntoString(wsdl));
        String seiImplementationBasePackageName = this.generatePackageNameFromTargetNamespaceInWsdl(targetNamespaceFromWsdl);
        this.writeSeiAndWebServiceClientPackageToCxfSpringBootMavenPropterties(buildDirectory, seiImplementationBasePackageName);
    }

    private void generateJaxbClassFiles(File wsdl, String jaxwsMavenPluginGoal, String dir2PutGeneratedClassesIn) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"jaxws-maven-plugin"), (String)MojoExecutor.version((String)"2.5.0"), (List)MojoExecutor.dependencies((Dependency[])new Dependency[]{MojoExecutor.dependency((String)"org.jvnet.jaxb2_commons", (String)"jaxb2-namespace-prefix", (String)"1.3")})), (String)MojoExecutor.goal((String)jaxwsMavenPluginGoal), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"wsdlDirectory"), (String)this.wsdlPathWithoutFileName(wsdl)), MojoExecutor.element((String)MojoExecutor.name((String)"wsdlLocation"), (String)this.constructWsdlLocation(wsdl)), MojoExecutor.element((String)MojoExecutor.name((String)"sourceDestDir"), (String)dir2PutGeneratedClassesIn), MojoExecutor.element((String)"vmArgs", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"vmArg", (String)"-Djavax.xml.accessExternalSchema=all -Djavax.xml.accessExternalDTD=all")}), MojoExecutor.element((String)"bindingDirectory", (String)this.wsdlPathWithoutFileName(wsdl)), MojoExecutor.element((String)"args", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"arg", (String)"-extension"), MojoExecutor.element((String)"arg", (String)"-B-Xnamespace-prefix")})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private String constructWsdlLocation(File wsdl) throws MojoExecutionException {
        String wsdlLocation = "/" + this.wsdlFolderInResources(wsdl) + this.wsdlFileName(wsdl);
        this.logWithPrefix("setting relative wsdlLocation into @WebServiceClient: " + wsdlLocation);
        return wsdlLocation;
    }

    private boolean isWsdlLocatedInTestResources(File wsdl) throws MojoExecutionException {
        return StringUtils.contains((CharSequence)wsdl.getPath(), (CharSequence)"/test/") || StringUtils.contains((CharSequence)wsdl.getPath(), (CharSequence)"\\test\\");
    }

    private boolean isWsdlLocatedInMainResources(File wsdl) throws MojoExecutionException {
        return StringUtils.contains((CharSequence)wsdl.getPath(), (CharSequence)"/main/") || StringUtils.contains((CharSequence)wsdl.getPath(), (CharSequence)"\\main\\");
    }

    private String wsdlFileName(File wsdl) throws MojoExecutionException {
        return wsdl.getName();
    }

    private String wsdlFolderInResources(File wsdl) {
        String folderAboveResourceDir = this.wsdlFileParentFolderName(wsdl, "");
        return folderAboveResourceDir;
    }

    private String wsdlFileParentFolderName(File wsdl, String folderAboveResourceDir) {
        if (!"resources".equals(wsdl.getParentFile().getName())) {
            folderAboveResourceDir = wsdl.getParentFile().getName() + "/" + folderAboveResourceDir;
            return this.wsdlFileParentFolderName(wsdl.getParentFile(), folderAboveResourceDir);
        }
        return folderAboveResourceDir;
    }

    private String wsdlPathWithoutFileName(File wsdl) throws MojoExecutionException {
        return wsdl.getParent();
    }

    protected File findWsdl(File buildDirectory) throws MojoExecutionException {
        String[] extension = new String[]{"wsdl"};
        Collection wsdls = FileUtils.listFiles((File)buildDirectory, (String[])extension, (boolean)true);
        this.filterOutWsdlsInsideBuildOutputFolder(wsdls);
        Optional wsdl = wsdls.stream().findFirst();
        if (wsdl.isPresent()) {
            return (File)wsdl.get();
        }
        throw new MojoExecutionException(WSDL_NOT_FOUND_ERROR_MESSAGE);
    }

    private void filterOutWsdlsInsideBuildOutputFolder(Collection<File> wsdls) {
        if (this.mavenProject != null) {
            String targetDirectory = this.mavenProject.getBuild().getOutputDirectory().replaceAll("classes$", "");
            wsdls.removeIf(f -> f.getAbsolutePath().startsWith(targetDirectory));
        }
    }

    private void addGeneratedClasses2Cp() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"build-helper-maven-plugin"), (String)MojoExecutor.version((String)"3.0.0")), (String)MojoExecutor.goal((String)"add-source"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"sources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"source", (String)GENERATED_SOURCES_TARGET_FOLDER)})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private void addGeneratedTestClasses2Cp() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"build-helper-maven-plugin"), (String)MojoExecutor.version((String)"3.0.0")), (String)MojoExecutor.goal((String)"add-test-source"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"sources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"source", (String)TEST_GENERATED_SOURCES_TARGET_FOLDER)})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private void logWithPrefix(String logMessage) {
        this.getLog().info((CharSequence)(LOG_PREFIX + logMessage));
    }

    protected String readTargetNamespaceFromWsdl(String wsdl) throws MojoExecutionException {
        Matcher matcher = BootCxfMojo.buildMatcher(wsdl, REGEX_FIND_TARGET_NAMESPACE_CONTENT);
        if (matcher.find()) {
            return matcher.group(0);
        }
        throw new MojoExecutionException(TARGET_NAMESPACE_COULDNT_BE_EXTRACTED);
    }

    protected static String readWsdlIntoString(File wsdl) throws MojoExecutionException {
        try {
            return FileUtils.readFileToString((File)wsdl, (Charset)Charset.defaultCharset());
        }
        catch (IOException ioEx) {
            throw new MojoExecutionException("Problems in transforming WSDL File to String.", (Exception)ioEx);
        }
    }

    private static Matcher buildMatcher(String string2SearchIn, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(string2SearchIn);
    }

    protected String generatePackageNameFromTargetNamespaceInWsdl(String targetNamespaceFromWsdl) throws MojoExecutionException {
        return XJC.getDefaultPackageName((String)targetNamespaceFromWsdl);
    }

    protected void writeSeiAndWebServiceClientPackageToCxfSpringBootMavenPropterties(String outputDirectory, String packageName) throws MojoExecutionException {
        this.writeCxfSpringBootMavenProperties(outputDirectory, SEI_AND_WEB_SERVICE_CLIENT_PACKAGE_NAME_KEY, packageName);
    }

    protected void writeSeiImplementationPackageToCxfSpringBootMavenPropterties(String outputDirectory, String packageName) throws MojoExecutionException {
        this.writeCxfSpringBootMavenProperties(outputDirectory, SEI_IMPLEMENTATION_PACKAGE_NAME_KEY, packageName);
    }

    protected void writeCxfSpringBootMavenProperties(String outputDirectory, String propertyKey, String packageName) throws MojoExecutionException {
        try {
            File cxfSpringBootMavenProperties = new File(outputDirectory + "/" + CXF_SPRING_BOOT_MAVEN_PROPERTIES_FILE_NAME);
            FileUtils.writeStringToFile((File)cxfSpringBootMavenProperties, (String)(propertyKey + "=" + packageName + "\n"), (Charset)Charset.defaultCharset(), (boolean)true);
        }
        catch (IOException ioExc) {
            throw new MojoExecutionException("Could not inject packageName into cxf-spring-boot-maven.properties.Have you set the pom groupId correctly?", (Exception)ioExc);
        }
    }

    public void cleanCxfSpringBootMavenProperties(String outputDirectory) throws MojoExecutionException {
        try {
            File cxfSpringBootMavenProperties = new File(outputDirectory + "/" + CXF_SPRING_BOOT_MAVEN_PROPERTIES_FILE_NAME);
            FileUtils.writeStringToFile((File)cxfSpringBootMavenProperties, (String)"", (Charset)Charset.defaultCharset());
        }
        catch (IOException ioExc) {
            throw new MojoExecutionException("Could not clean cxf-spring-boot-maven.properties", (Exception)ioExc);
        }
    }
}

