/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric;

import de.codecentric.Files;
import de.codecentric.StagingProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY)
class CheckStagingPropertiesMojo
extends AbstractMojo {
    @Parameter(defaultValue="src/main/resources")
    File directory;
    @Parameter
    List<String> groups;
    private List<String> fileNames = new LinkedList<String>();

    CheckStagingPropertiesMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isGroupingEnabled()) {
            for (String group : this.groups) {
                this.doChecks(group, this.getProperties(group));
            }
        } else {
            this.doChecks("", this.getProperties());
        }
    }

    private ArrayList<Properties> getPropertiesRecursively(File directory, String pattern) throws MojoExecutionException {
        ArrayList<Properties> propertyFiles = new ArrayList<Properties>(20);
        if (directory == null || !directory.exists()) {
            this.getLog().warn((CharSequence)("Directory `" + (directory == null ? "" : directory.getAbsolutePath()) + "` does not exist. Skipping."));
            return propertyFiles;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            this.getLog().warn((CharSequence)("Directory `" + directory.getAbsolutePath() + "` does not denote a directory. Skipping."));
            return propertyFiles;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                propertyFiles.addAll(this.getPropertiesRecursively(file, pattern));
                this.fileNames.add(file.getName());
                continue;
            }
            if (!this.isPropertiesFile(file) || !this.matchesGroupPattern(pattern, file)) continue;
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(file.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot read file `" + file.getName() + "`", (Exception)e);
            }
            propertyFiles.add(props);
            this.fileNames.add(file.getName());
        }
        return propertyFiles;
    }

    ArrayList<Properties> getProperties() throws MojoExecutionException {
        return this.getPropertiesRecursively(this.directory, null);
    }

    private ArrayList<Properties> getProperties(String pattern) throws MojoExecutionException {
        return this.getPropertiesRecursively(this.directory, pattern);
    }

    private void doChecks(String group, ArrayList<Properties> props) throws MojoExecutionException, MojoFailureException {
        if (props.size() > 1) {
            if (!StagingProperties.sizesEqual(props)) {
                throw new MojoFailureException("In group `" + group + "`: Sizes (number of keys) are not equal");
            }
            if (!StagingProperties.keysEqual(props)) {
                throw new MojoFailureException("In group `" + group + "`: Keys are not equal");
            }
            if (!StagingProperties.valuesPresent(props)) {
                LinkedList<String> errors = new LinkedList<String>();
                for (int i = 0; i < this.fileNames.size(); ++i) {
                    String missingValues = "";
                    for (Object key : props.get(i).keySet()) {
                        String value = (String)props.get(i).get(key);
                        if (value != null && !"".equals(value)) continue;
                        missingValues = missingValues + key + "\n";
                    }
                    errors.add("file: " + this.fileNames.get(i) + ", keys: \n" + missingValues);
                }
                if (group == null || "".equals(group)) {
                    throw new MojoFailureException("There are some empty values in: " + errors + "`");
                }
                throw new MojoFailureException("There are some empty values in group `" + group + "` and `" + errors + "`");
            }
        }
    }

    private boolean isGroupingEnabled() {
        return this.groups != null && this.groups.size() > 0;
    }

    private boolean matchesGroupPattern(String pattern, File file) {
        return Files.matchesGroup(file, pattern);
    }

    private boolean isPropertiesFile(File file) {
        return Files.isPropertiesFile(file);
    }
}

