/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import org.springframework.boot.web.client.RootUriTemplateHandler;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.SimpleRequestExpectationManager;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

public class RootUriRequestExpectationManager
implements RequestExpectationManager {
    private final String rootUri;
    private final RequestExpectationManager expectationManager;

    public RootUriRequestExpectationManager(String rootUri, RequestExpectationManager expectationManager) {
        Assert.notNull((Object)rootUri, "RootUri must not be null");
        Assert.notNull((Object)expectationManager, "ExpectationManager must not be null");
        this.rootUri = rootUri;
        this.expectationManager = expectationManager;
    }

    public ResponseActions expectRequest(ExpectedCount count, RequestMatcher requestMatcher) {
        return this.expectationManager.expectRequest(count, requestMatcher);
    }

    public ClientHttpResponse validateRequest(ClientHttpRequest request) throws IOException {
        String uri = request.getURI().toString();
        if (uri.startsWith(this.rootUri)) {
            request = this.replaceURI(request, uri.substring(this.rootUri.length()));
        }
        try {
            return this.expectationManager.validateRequest(request);
        }
        catch (AssertionError ex) {
            String message = ((Throwable)((Object)ex)).getMessage();
            String prefix = "Request URI expected:</";
            if (message != null && message.startsWith(prefix)) {
                throw new AssertionError((Object)("Request URI expected:<" + this.rootUri + message.substring(prefix.length() - 1)));
            }
            throw ex;
        }
    }

    private ClientHttpRequest replaceURI(ClientHttpRequest request, String replacementUri) {
        try {
            URI uri = new URI(replacementUri);
            if (request instanceof MockClientHttpRequest) {
                MockClientHttpRequest mockClientHttpRequest = (MockClientHttpRequest)request;
                mockClientHttpRequest.setURI(uri);
                return mockClientHttpRequest;
            }
            return new ReplaceUriClientHttpRequest(uri, request);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void verify() {
        this.expectationManager.verify();
    }

    public void verify(Duration timeout) {
        this.expectationManager.verify(timeout);
    }

    public void reset() {
        this.expectationManager.reset();
    }

    public static MockRestServiceServer bindTo(RestTemplate restTemplate) {
        return RootUriRequestExpectationManager.bindTo(restTemplate, (RequestExpectationManager)new SimpleRequestExpectationManager());
    }

    public static MockRestServiceServer bindTo(RestTemplate restTemplate, RequestExpectationManager expectationManager) {
        MockRestServiceServer.MockRestServiceServerBuilder builder = MockRestServiceServer.bindTo((RestTemplate)restTemplate);
        return builder.build(RootUriRequestExpectationManager.forRestTemplate(restTemplate, expectationManager));
    }

    public static RequestExpectationManager forRestTemplate(RestTemplate restTemplate, RequestExpectationManager expectationManager) {
        Assert.notNull((Object)restTemplate, "RestTemplate must not be null");
        UriTemplateHandler templateHandler = restTemplate.getUriTemplateHandler();
        if (templateHandler instanceof RootUriTemplateHandler) {
            RootUriTemplateHandler rootHandler = (RootUriTemplateHandler)templateHandler;
            return new RootUriRequestExpectationManager(rootHandler.getRootUri(), expectationManager);
        }
        return expectationManager;
    }

    private static class ReplaceUriClientHttpRequest
    extends HttpRequestWrapper
    implements ClientHttpRequest {
        private final URI uri;

        ReplaceUriClientHttpRequest(URI uri, ClientHttpRequest request) {
            super((HttpRequest)request);
            this.uri = uri;
        }

        public URI getURI() {
            return this.uri;
        }

        public OutputStream getBody() throws IOException {
            return this.getRequest().getBody();
        }

        public ClientHttpResponse execute() throws IOException {
            return this.getRequest().execute();
        }

        public ClientHttpRequest getRequest() {
            return (ClientHttpRequest)super.getRequest();
        }
    }
}

