/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.test.web.client.RootUriRequestExpectationManager;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.SimpleRequestExpectationManager;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class MockServerRestTemplateCustomizer
implements RestTemplateCustomizer {
    private final Map<RestTemplate, RequestExpectationManager> expectationManagers = new ConcurrentHashMap<RestTemplate, RequestExpectationManager>();
    private final Map<RestTemplate, MockRestServiceServer> servers = new ConcurrentHashMap<RestTemplate, MockRestServiceServer>();
    private final Supplier<? extends RequestExpectationManager> expectationManagerSupplier;
    private boolean detectRootUri = true;

    public MockServerRestTemplateCustomizer() {
        this(SimpleRequestExpectationManager::new);
    }

    public MockServerRestTemplateCustomizer(Class<? extends RequestExpectationManager> expectationManager) {
        this(() -> (RequestExpectationManager)BeanUtils.instantiateClass((Class)expectationManager));
        Assert.notNull(expectationManager, "ExpectationManager must not be null");
    }

    public MockServerRestTemplateCustomizer(Supplier<? extends RequestExpectationManager> expectationManagerSupplier) {
        Assert.notNull(expectationManagerSupplier, "ExpectationManagerSupplier must not be null");
        this.expectationManagerSupplier = expectationManagerSupplier;
    }

    public void setDetectRootUri(boolean detectRootUri) {
        this.detectRootUri = detectRootUri;
    }

    public void customize(RestTemplate restTemplate) {
        RequestExpectationManager expectationManager = this.createExpectationManager();
        if (this.detectRootUri) {
            expectationManager = RootUriRequestExpectationManager.forRestTemplate(restTemplate, expectationManager);
        }
        MockRestServiceServer server = MockRestServiceServer.bindTo((RestTemplate)restTemplate).build(expectationManager);
        this.expectationManagers.put(restTemplate, expectationManager);
        this.servers.put(restTemplate, server);
    }

    protected RequestExpectationManager createExpectationManager() {
        return this.expectationManagerSupplier.get();
    }

    public MockRestServiceServer getServer() {
        Assert.state(!this.servers.isEmpty(), "Unable to return a single MockRestServiceServer since MockServerRestTemplateCustomizer has not been bound to a RestTemplate");
        Assert.state(this.servers.size() == 1, "Unable to return a single MockRestServiceServer since MockServerRestTemplateCustomizer has been bound to more than one RestTemplate");
        return this.servers.values().iterator().next();
    }

    public Map<RestTemplate, RequestExpectationManager> getExpectationManagers() {
        return this.expectationManagers;
    }

    public MockRestServiceServer getServer(RestTemplate restTemplate) {
        return this.servers.get(restTemplate);
    }

    public Map<RestTemplate, MockRestServiceServer> getServers() {
        return Collections.unmodifiableMap(this.servers);
    }
}

