/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web;

import java.util.Map;
import java.util.Objects;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

class SpringBootTestRandomPortEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String MANAGEMENT_PORT_PROPERTY = "management.server.port";
    private static final String SERVER_PORT_PROPERTY = "server.port";

    SpringBootTestRandomPortEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MapPropertySource source = (MapPropertySource)environment.getPropertySources().get("Inlined Test Properties");
        if (source == null || this.isTestServerPortFixed(source, environment) || this.isTestManagementPortConfigured(source)) {
            return;
        }
        Integer managementPort = this.getPropertyAsInteger(environment, MANAGEMENT_PORT_PROPERTY, null);
        if (managementPort == null || managementPort.equals(-1) || managementPort.equals(0)) {
            return;
        }
        Integer serverPort = this.getPropertyAsInteger(environment, SERVER_PORT_PROPERTY, 8080);
        if (!managementPort.equals(serverPort)) {
            ((Map)source.getSource()).put(MANAGEMENT_PORT_PROPERTY, "0");
        } else {
            ((Map)source.getSource()).put(MANAGEMENT_PORT_PROPERTY, "");
        }
    }

    private boolean isTestServerPortFixed(MapPropertySource source, ConfigurableEnvironment environment) {
        return !Integer.valueOf(0).equals(this.getPropertyAsInteger(source, SERVER_PORT_PROPERTY, environment));
    }

    private boolean isTestManagementPortConfigured(PropertySource<?> source) {
        return source.getProperty(MANAGEMENT_PORT_PROPERTY) != null;
    }

    private Integer getPropertyAsInteger(ConfigurableEnvironment environment, String property, Integer defaultValue) {
        return environment.getPropertySources().stream().filter(source -> !source.getName().equals("Inlined Test Properties")).map(source -> this.getPropertyAsInteger((PropertySource<?>)source, property, environment)).filter(Objects::nonNull).findFirst().orElse(defaultValue);
    }

    private Integer getPropertyAsInteger(PropertySource<?> source, String property, ConfigurableEnvironment environment) {
        Object value = source.getProperty(property);
        if (value == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue(Integer.class, value)) {
            return (Integer)value;
        }
        try {
            return environment.getConversionService().convert(value, Integer.class);
        }
        catch (ConversionFailedException ex) {
            if (value instanceof String) {
                String string = (String)value;
                return this.getResolvedValueIfPossible(environment, string);
            }
            throw ex;
        }
    }

    private Integer getResolvedValueIfPossible(ConfigurableEnvironment environment, String value) {
        String resolvedValue = environment.resolveRequiredPlaceholders(value);
        return environment.getConversionService().convert(resolvedValue, Integer.class);
    }
}

