/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.jayway.jsonpath.Configuration;
import org.assertj.core.api.AssertProvider;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public final class JsonContent<T>
implements AssertProvider<JsonContentAssert> {
    private final Class<?> resourceLoadClass;
    private final ResolvableType type;
    private final String json;
    private final Configuration configuration;

    public JsonContent(Class<?> resourceLoadClass, ResolvableType type, String json) {
        this(resourceLoadClass, type, json, Configuration.defaultConfiguration());
    }

    JsonContent(Class<?> resourceLoadClass, ResolvableType type, String json, Configuration configuration) {
        Assert.notNull(resourceLoadClass, "ResourceLoadClass must not be null");
        Assert.notNull((Object)json, "JSON must not be null");
        Assert.notNull((Object)configuration, "Configuration must not be null");
        this.resourceLoadClass = resourceLoadClass;
        this.type = type;
        this.json = json;
        this.configuration = configuration;
    }

    @Deprecated(since="1.5.7", forRemoval=false)
    public JsonContentAssert assertThat() {
        return new JsonContentAssert(this.resourceLoadClass, null, this.json, this.configuration);
    }

    public String getJson() {
        return this.json;
    }

    public String toString() {
        String createdFrom = this.type != null ? " created from " + this.type : "";
        return "JsonContent " + this.json + createdFrom;
    }
}

