/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.context.annotation.UserConfigurations;
import org.springframework.boot.test.context.assertj.ApplicationContextAssertProvider;
import org.springframework.boot.test.context.runner.ContextConsumer;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.Assert;

public abstract class AbstractApplicationContextRunner<SELF extends AbstractApplicationContextRunner<SELF, C, A>, C extends ConfigurableApplicationContext, A extends ApplicationContextAssertProvider<C>> {
    private final RunnerConfiguration<C> runnerConfiguration;
    private final Function<RunnerConfiguration<C>, SELF> instanceFactory;

    protected AbstractApplicationContextRunner(Supplier<C> contextFactory, Function<RunnerConfiguration<C>, SELF> instanceFactory) {
        Assert.notNull(contextFactory, "ContextFactory must not be null");
        Assert.notNull(contextFactory, "RunnerConfiguration must not be null");
        this.runnerConfiguration = new RunnerConfiguration<C>(contextFactory);
        this.instanceFactory = instanceFactory;
    }

    protected AbstractApplicationContextRunner(RunnerConfiguration<C> configuration, Function<RunnerConfiguration<C>, SELF> instanceFactory) {
        Assert.notNull(configuration, "RunnerConfiguration must not be null");
        Assert.notNull(instanceFactory, "instanceFactory must not be null");
        this.runnerConfiguration = configuration;
        this.instanceFactory = instanceFactory;
    }

    public SELF withAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        return this.newInstance(this.runnerConfiguration.withAllowBeanDefinitionOverriding(allowBeanDefinitionOverriding));
    }

    public SELF withAllowCircularReferences(boolean allowCircularReferences) {
        return this.newInstance(this.runnerConfiguration.withAllowCircularReferences(allowCircularReferences));
    }

    public SELF withInitializer(ApplicationContextInitializer<? super C> initializer) {
        Assert.notNull(initializer, "Initializer must not be null");
        return this.newInstance(this.runnerConfiguration.withInitializer(initializer));
    }

    public SELF withPropertyValues(String ... pairs) {
        return this.newInstance(this.runnerConfiguration.withPropertyValues(pairs));
    }

    public SELF withSystemProperties(String ... pairs) {
        return this.newInstance(this.runnerConfiguration.withSystemProperties(pairs));
    }

    public SELF withClassLoader(ClassLoader classLoader) {
        return this.newInstance(this.runnerConfiguration.withClassLoader(classLoader));
    }

    public SELF withParent(ApplicationContext parent) {
        return this.newInstance(this.runnerConfiguration.withParent(parent));
    }

    public <T> SELF withBean(Class<T> type, Object ... constructorArgs) {
        return this.withBean(null, type, constructorArgs);
    }

    public <T> SELF withBean(String name, Class<T> type, Object ... constructorArgs) {
        return this.newInstance(this.runnerConfiguration.withBean(name, type, constructorArgs));
    }

    public <T> SELF withBean(Class<T> type, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        return this.withBean(null, type, supplier, customizers);
    }

    public <T> SELF withBean(String name, Class<T> type, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        return this.newInstance(this.runnerConfiguration.withBean(name, type, supplier, customizers));
    }

    public SELF withUserConfiguration(Class<?> ... configurationClasses) {
        return this.withConfiguration((Configurations)UserConfigurations.of((Class[])configurationClasses));
    }

    public SELF withConfiguration(Configurations configurations) {
        Assert.notNull((Object)configurations, "Configurations must not be null");
        return this.newInstance(this.runnerConfiguration.withConfiguration(configurations));
    }

    public SELF with(Function<SELF, SELF> customizer) {
        return (SELF)((AbstractApplicationContextRunner)customizer.apply(this));
    }

    private SELF newInstance(RunnerConfiguration<C> runnerConfiguration) {
        return (SELF)((AbstractApplicationContextRunner)this.instanceFactory.apply(runnerConfiguration));
    }

    public SELF run(ContextConsumer<? super A> consumer) {
        this.withContextClassLoader(this.runnerConfiguration.classLoader, () -> this.runnerConfiguration.systemProperties.applyToSystemProperties(() -> this.consumeAssertableContext(true, consumer)));
        return (SELF)this;
    }

    public SELF prepare(ContextConsumer<? super A> consumer) {
        this.withContextClassLoader(this.runnerConfiguration.classLoader, () -> this.runnerConfiguration.systemProperties.applyToSystemProperties(() -> this.consumeAssertableContext(false, consumer)));
        return (SELF)this;
    }

    private void consumeAssertableContext(boolean refresh, ContextConsumer<? super A> consumer) {
        try (A context = this.createAssertableContext(refresh);){
            this.accept(consumer, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withContextClassLoader(ClassLoader classLoader, Runnable action) {
        if (classLoader == null) {
            action.run();
        } else {
            Thread currentThread = Thread.currentThread();
            ClassLoader previous = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(classLoader);
            try {
                action.run();
            }
            finally {
                currentThread.setContextClassLoader(previous);
            }
        }
    }

    private A createAssertableContext(boolean refresh) {
        ResolvableType resolvableType = ResolvableType.forClass(AbstractApplicationContextRunner.class, this.getClass());
        Class<?> assertType = resolvableType.resolveGeneric(1);
        Class<?> contextType = resolvableType.resolveGeneric(2);
        return (A)ApplicationContextAssertProvider.get(assertType, contextType, () -> this.createAndLoadContext(refresh));
    }

    private C createAndLoadContext(boolean refresh) {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.runnerConfiguration.contextFactory.get();
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory instanceof AbstractAutowireCapableBeanFactory) {
            AbstractAutowireCapableBeanFactory autowireCapableBeanFactory = (AbstractAutowireCapableBeanFactory)beanFactory;
            autowireCapableBeanFactory.setAllowCircularReferences(this.runnerConfiguration.allowCircularReferences);
            if (beanFactory instanceof DefaultListableBeanFactory) {
                DefaultListableBeanFactory listableBeanFactory = (DefaultListableBeanFactory)beanFactory;
                listableBeanFactory.setAllowBeanDefinitionOverriding(this.runnerConfiguration.allowBeanDefinitionOverriding);
            }
        }
        try {
            this.configureContext(context, refresh);
            return (C)context;
        }
        catch (RuntimeException ex) {
            context.close();
            throw ex;
        }
    }

    private void configureContext(C context, boolean refresh) {
        if (this.runnerConfiguration.parent != null) {
            context.setParent(this.runnerConfiguration.parent);
        }
        if (this.runnerConfiguration.classLoader != null) {
            Assert.isInstanceOf(DefaultResourceLoader.class, context);
            ((DefaultResourceLoader)context).setClassLoader(this.runnerConfiguration.classLoader);
        }
        this.runnerConfiguration.environmentProperties.applyTo((ConfigurableApplicationContext)context);
        this.runnerConfiguration.beanRegistrations.forEach(registration -> registration.apply((ConfigurableApplicationContext)context));
        this.runnerConfiguration.initializers.forEach(initializer -> initializer.initialize(context));
        Class[] classes = Configurations.getClasses(this.runnerConfiguration.configurations);
        if (classes.length > 0) {
            ((AnnotationConfigRegistry)context).register(classes);
        }
        if (refresh) {
            context.refresh();
        }
    }

    private void accept(ContextConsumer<? super A> consumer, A context) {
        try {
            consumer.accept(context);
        }
        catch (Throwable ex) {
            this.rethrow(ex);
        }
    }

    private <E extends Throwable> void rethrow(Throwable e) throws E {
        throw e;
    }

    protected static final class RunnerConfiguration<C extends ConfigurableApplicationContext> {
        private final Supplier<C> contextFactory;
        private boolean allowBeanDefinitionOverriding = false;
        private boolean allowCircularReferences = false;
        private List<ApplicationContextInitializer<? super C>> initializers = Collections.emptyList();
        private TestPropertyValues environmentProperties = TestPropertyValues.empty();
        private TestPropertyValues systemProperties = TestPropertyValues.empty();
        private ClassLoader classLoader;
        private ApplicationContext parent;
        private List<BeanRegistration<?>> beanRegistrations = Collections.emptyList();
        private List<Configurations> configurations = Collections.emptyList();

        private RunnerConfiguration(Supplier<C> contextFactory) {
            this.contextFactory = contextFactory;
        }

        private RunnerConfiguration(RunnerConfiguration<C> source) {
            this.contextFactory = source.contextFactory;
            this.allowBeanDefinitionOverriding = source.allowBeanDefinitionOverriding;
            this.allowCircularReferences = source.allowCircularReferences;
            this.initializers = source.initializers;
            this.environmentProperties = source.environmentProperties;
            this.systemProperties = source.systemProperties;
            this.classLoader = source.classLoader;
            this.parent = source.parent;
            this.beanRegistrations = source.beanRegistrations;
            this.configurations = source.configurations;
        }

        private RunnerConfiguration<C> withAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
            return config;
        }

        private RunnerConfiguration<C> withAllowCircularReferences(boolean allowCircularReferences) {
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.allowCircularReferences = allowCircularReferences;
            return config;
        }

        private RunnerConfiguration<C> withInitializer(ApplicationContextInitializer<? super C> initializer) {
            Assert.notNull(initializer, "Initializer must not be null");
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.initializers = RunnerConfiguration.add(config.initializers, initializer);
            return config;
        }

        private RunnerConfiguration<C> withPropertyValues(String ... pairs) {
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.environmentProperties = config.environmentProperties.and(pairs);
            return config;
        }

        private RunnerConfiguration<C> withSystemProperties(String ... pairs) {
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.systemProperties = config.systemProperties.and(pairs);
            return config;
        }

        private RunnerConfiguration<C> withClassLoader(ClassLoader classLoader) {
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.classLoader = classLoader;
            return config;
        }

        private RunnerConfiguration<C> withParent(ApplicationContext parent) {
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.parent = parent;
            return config;
        }

        private <T> RunnerConfiguration<C> withBean(String name, Class<T> type, Object ... constructorArgs) {
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.beanRegistrations = RunnerConfiguration.add(config.beanRegistrations, new BeanRegistration<T>(name, type, constructorArgs));
            return config;
        }

        private <T> RunnerConfiguration<C> withBean(String name, Class<T> type, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.beanRegistrations = RunnerConfiguration.add(config.beanRegistrations, new BeanRegistration<T>(name, type, supplier, customizers));
            return config;
        }

        private RunnerConfiguration<C> withConfiguration(Configurations configurations) {
            Assert.notNull((Object)configurations, "Configurations must not be null");
            RunnerConfiguration<C> config = new RunnerConfiguration<C>(this);
            config.configurations = RunnerConfiguration.add(config.configurations, configurations);
            return config;
        }

        private static <T> List<T> add(List<T> list, T element) {
            ArrayList<T> result = new ArrayList<T>(list);
            result.add(element);
            return result;
        }
    }

    protected static final class BeanRegistration<T> {
        Consumer<GenericApplicationContext> registrar;

        public BeanRegistration(String name, Class<T> type, Object ... constructorArgs) {
            this.registrar = context -> context.registerBean(name, type, constructorArgs);
        }

        public BeanRegistration(String name, Class<T> type, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
            this.registrar = context -> context.registerBean(name, type, supplier, customizers);
        }

        public void apply(ConfigurableApplicationContext context) {
            Assert.isInstanceOf(GenericApplicationContext.class, context);
            this.registrar.accept((GenericApplicationContext)context);
        }
    }
}

