/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.web.exchanges;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.boot.actuate.web.exchanges.HttpExchange;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;

public class InMemoryHttpExchangeRepository
implements HttpExchangeRepository {
    private int capacity = 100;
    private boolean reverse = true;
    private final List<HttpExchange> httpExchanges = new LinkedList<HttpExchange>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReverse(boolean reverse) {
        List<HttpExchange> list = this.httpExchanges;
        synchronized (list) {
            this.reverse = reverse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        List<HttpExchange> list = this.httpExchanges;
        synchronized (list) {
            this.capacity = capacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpExchange> findAll() {
        List<HttpExchange> list = this.httpExchanges;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<HttpExchange>(this.httpExchanges));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(HttpExchange exchange2) {
        List<HttpExchange> list = this.httpExchanges;
        synchronized (list) {
            while (this.httpExchanges.size() >= this.capacity) {
                this.httpExchanges.remove(this.reverse ? this.capacity - 1 : 0);
            }
            if (this.reverse) {
                this.httpExchanges.add(0, exchange2);
            } else {
                this.httpExchanges.add(exchange2);
            }
        }
    }
}

