/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.boot.actuate.metrics.http.Outcome;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;

@Deprecated(since="3.0.0", forRemoval=true)
public final class WebFluxTags {
    private static final Tag URI_NOT_FOUND = Tag.of("uri", "NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of("uri", "REDIRECTION");
    private static final Tag URI_ROOT = Tag.of("uri", "root");
    private static final Tag URI_UNKNOWN = Tag.of("uri", "UNKNOWN");
    private static final Tag EXCEPTION_NONE = Tag.of("exception", "None");
    private static final Pattern FORWARD_SLASHES_PATTERN = Pattern.compile("//+");
    private static final Set<String> DISCONNECTED_CLIENT_EXCEPTIONS = new HashSet<String>(Arrays.asList("AbortedException", "ClientAbortException", "EOFException", "EofException"));

    private WebFluxTags() {
    }

    public static Tag method(ServerWebExchange exchange2) {
        return Tag.of("method", exchange2.getRequest().getMethod().name());
    }

    public static Tag status(ServerWebExchange exchange2) {
        HttpStatusCode status = exchange2.getResponse().getStatusCode();
        if (status == null) {
            status = HttpStatus.OK;
        }
        return Tag.of("status", String.valueOf(status.value()));
    }

    public static Tag uri(ServerWebExchange exchange2) {
        return WebFluxTags.uri(exchange2, false);
    }

    public static Tag uri(ServerWebExchange exchange2, boolean ignoreTrailingSlash) {
        String path;
        PathPattern pathPattern = (PathPattern)exchange2.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (pathPattern != null) {
            String patternString = pathPattern.getPatternString();
            if (ignoreTrailingSlash && patternString.length() > 1) {
                patternString = WebFluxTags.removeTrailingSlash(patternString);
            }
            if (patternString.isEmpty()) {
                return URI_ROOT;
            }
            return Tag.of("uri", patternString);
        }
        HttpStatusCode status = exchange2.getResponse().getStatusCode();
        if (status != null) {
            if (status.is3xxRedirection()) {
                return URI_REDIRECTION;
            }
            if (status == HttpStatus.NOT_FOUND) {
                return URI_NOT_FOUND;
            }
        }
        if ((path = WebFluxTags.getPathInfo(exchange2)).isEmpty()) {
            return URI_ROOT;
        }
        return URI_UNKNOWN;
    }

    private static String getPathInfo(ServerWebExchange exchange2) {
        String path = exchange2.getRequest().getPath().value();
        String uri = StringUtils.hasText(path) ? path : "/";
        String singleSlashes = FORWARD_SLASHES_PATTERN.matcher(uri).replaceAll("/");
        return WebFluxTags.removeTrailingSlash(singleSlashes);
    }

    private static String removeTrailingSlash(String text) {
        if (!StringUtils.hasLength(text)) {
            return text;
        }
        return text.endsWith("/") ? text.substring(0, text.length() - 1) : text;
    }

    public static Tag exception(Throwable exception) {
        if (exception != null) {
            String simpleName = exception.getClass().getSimpleName();
            return Tag.of("exception", StringUtils.hasText(simpleName) ? simpleName : exception.getClass().getName());
        }
        return EXCEPTION_NONE;
    }

    public static Tag outcome(ServerWebExchange exchange2, Throwable exception) {
        if (exception != null && DISCONNECTED_CLIENT_EXCEPTIONS.contains(exception.getClass().getSimpleName())) {
            return Outcome.UNKNOWN.asTag();
        }
        HttpStatusCode statusCode = exchange2.getResponse().getStatusCode();
        Outcome outcome = statusCode != null ? Outcome.forStatus(statusCode.value()) : Outcome.SUCCESS;
        return outcome.asTag();
    }
}

