/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.client;

import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.regex.Pattern;
import org.springframework.boot.actuate.metrics.http.Outcome;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;

@Deprecated(since="3.0.0", forRemoval=true)
public final class WebClientExchangeTags {
    private static final String URI_TEMPLATE_ATTRIBUTE = WebClient.class.getName() + ".uriTemplate";
    private static final Tag IO_ERROR = Tag.of("status", "IO_ERROR");
    private static final Tag CLIENT_ERROR = Tag.of("status", "CLIENT_ERROR");
    private static final Pattern PATTERN_BEFORE_PATH = Pattern.compile("^https?://[^/]+/");
    private static final Tag CLIENT_NAME_NONE = Tag.of("client.name", "none");

    private WebClientExchangeTags() {
    }

    public static Tag method(ClientRequest request) {
        return Tag.of("method", request.method().name());
    }

    public static Tag uri(ClientRequest request) {
        String uri = (String)request.attribute(URI_TEMPLATE_ATTRIBUTE).orElseGet(() -> request.url().toString());
        return Tag.of("uri", WebClientExchangeTags.extractPath(uri));
    }

    private static String extractPath(String url) {
        String path = PATTERN_BEFORE_PATH.matcher(url).replaceFirst("");
        return path.startsWith("/") ? path : "/" + path;
    }

    public static Tag status(ClientResponse response, Throwable throwable) {
        if (response != null) {
            return Tag.of("status", String.valueOf(response.statusCode().value()));
        }
        if (throwable != null) {
            return throwable instanceof IOException ? IO_ERROR : CLIENT_ERROR;
        }
        return CLIENT_ERROR;
    }

    public static Tag clientName(ClientRequest request) {
        String host = request.url().getHost();
        if (host == null) {
            return CLIENT_NAME_NONE;
        }
        return Tag.of("client.name", host);
    }

    public static Tag outcome(ClientResponse response) {
        Outcome outcome = response != null ? Outcome.forStatus(response.statusCode().value()) : Outcome.UNKNOWN;
        return outcome.asTag();
    }
}

