/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.net.InetAddress;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="management.server", ignoreUnknownFields=true)
public class ManagementServerProperties {
    private Integer port;
    private InetAddress address;
    private String basePath = "";
    @NestedConfigurationProperty
    private Ssl ssl;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = this.cleanBasePath(basePath);
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    private String cleanBasePath(String basePath) {
        Object candidate = null;
        if (StringUtils.hasLength(basePath)) {
            candidate = basePath.strip();
        }
        if (StringUtils.hasText(candidate)) {
            if (!((String)candidate).startsWith("/")) {
                candidate = "/" + (String)candidate;
            }
            if (((String)candidate).endsWith("/")) {
                candidate = ((String)candidate).substring(0, ((String)candidate).length() - 1);
            }
        }
        return candidate;
    }
}

