/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.wavefront;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.metrics.export.properties.PushRegistryProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="management.wavefront")
public class WavefrontProperties {
    private URI uri = URI.create("https://longboard.wavefront.com");
    private String source;
    private String apiToken;
    private final Application application = new Application();
    private final Sender sender = new Sender();
    private final Metrics metrics = new Metrics();
    private Set<String> traceDerivedCustomTagKeys = new HashSet<String>();

    public Application getApplication() {
        return this.application;
    }

    public Sender getSender() {
        return this.sender;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public URI getEffectiveUri() {
        if (this.usesProxy()) {
            return URI.create(this.uri.toString().replace("proxy://", "http://"));
        }
        return this.uri;
    }

    public String getApiTokenOrThrow() {
        if (this.apiToken == null && !this.usesProxy()) {
            throw new InvalidConfigurationPropertyValueException("management.wavefront.api-token", null, "This property is mandatory whenever publishing directly to the Wavefront API");
        }
        return this.apiToken;
    }

    public String getSourceOrDefault() {
        if (this.source != null) {
            return this.source;
        }
        return this.getSourceDefault();
    }

    private String getSourceDefault() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return "unknown";
        }
    }

    private boolean usesProxy() {
        return "proxy".equals(this.uri.getScheme());
    }

    public Set<String> getTraceDerivedCustomTagKeys() {
        return this.traceDerivedCustomTagKeys;
    }

    public void setTraceDerivedCustomTagKeys(Set<String> traceDerivedCustomTagKeys) {
        this.traceDerivedCustomTagKeys = traceDerivedCustomTagKeys;
    }

    public static class Application {
        private String name = "unnamed_application";
        private String serviceName;
        private String clusterName;
        private String shardName;

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public String getShardName() {
            return this.shardName;
        }

        public void setShardName(String shardName) {
            this.shardName = shardName;
        }
    }

    public static class Sender {
        private int maxQueueSize = 50000;
        private Duration flushInterval = Duration.ofSeconds(1L);
        private DataSize messageSize = DataSize.ofBytes(Integer.MAX_VALUE);
        private int batchSize = 10000;

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public Duration getFlushInterval() {
            return this.flushInterval;
        }

        public void setFlushInterval(Duration flushInterval) {
            this.flushInterval = flushInterval;
        }

        public DataSize getMessageSize() {
            return this.messageSize;
        }

        public void setMessageSize(DataSize messageSize) {
            this.messageSize = messageSize;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }
    }

    public static class Metrics {
        private Export export = new Export();

        public Export getExport() {
            return this.export;
        }

        public void setExport(Export export) {
            this.export = export;
        }

        public static class Export
        extends PushRegistryProperties {
            private String globalPrefix;

            public String getGlobalPrefix() {
                return this.globalPrefix;
            }

            public void setGlobalPrefix(String globalPrefix) {
                this.globalPrefix = globalPrefix;
            }

            @Override
            public Integer getBatchSize() {
                throw new UnsupportedOperationException("Use Sender.getBatchSize() instead");
            }

            @Override
            public void setBatchSize(Integer batchSize) {
                throw new UnsupportedOperationException("Use Sender.setBatchSize(int) instead");
            }
        }
    }
}

