/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.wavefront;

import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import org.springframework.boot.actuate.autoconfigure.wavefront.WavefrontProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={ApplicationTags.class, WavefrontSender.class})
@EnableConfigurationProperties(value={WavefrontProperties.class})
public class WavefrontAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ApplicationTags wavefrontApplicationTags(Environment environment, WavefrontProperties properties) {
        WavefrontProperties.Application application = properties.getApplication();
        String serviceName = application.getServiceName();
        serviceName = StringUtils.hasText(serviceName) ? serviceName : environment.getProperty("spring.application.name", "unnamed_service");
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        ApplicationTags.Builder builder = new ApplicationTags.Builder(application.getName(), serviceName);
        map.from(application::getClusterName).to(arg_0 -> ((ApplicationTags.Builder)builder).cluster(arg_0));
        map.from(application::getShardName).to(arg_0 -> ((ApplicationTags.Builder)builder).shard(arg_0));
        return builder.build();
    }
}

