/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.servlet;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.OnlyOnceLoggingDenyMeterFilter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.actuate.autoconfigure.observation.web.servlet.ServerRequestObservationConventionAdapter;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsContributor;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.ConditionalOnMissingFilterBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.observation.ServerRequestObservationConvention;
import org.springframework.web.filter.ServerHttpObservationFilter;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, ObservationAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class, Observation.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@EnableConfigurationProperties(value={MetricsProperties.class, ObservationProperties.class})
public class WebMvcObservationAutoConfiguration {
    private final MetricsProperties metricsProperties;
    private final ObservationProperties observationProperties;

    public WebMvcObservationAutoConfiguration(ObservationProperties observationProperties, MetricsProperties metricsProperties) {
        this.observationProperties = observationProperties;
        this.metricsProperties = metricsProperties;
    }

    @Bean
    @ConditionalOnMissingFilterBean
    public FilterRegistrationBean<ServerHttpObservationFilter> webMvcObservationFilter(ObservationRegistry registry, ObjectProvider<ServerRequestObservationConvention> customConvention, ObjectProvider<WebMvcTagsProvider> customTagsProvider, ObjectProvider<WebMvcTagsContributor> contributorsProvider) {
        String name = WebMvcObservationAutoConfiguration.httpRequestsMetricName(this.observationProperties, this.metricsProperties);
        ServerRequestObservationConvention convention = WebMvcObservationAutoConfiguration.createConvention((ServerRequestObservationConvention)customConvention.getIfAvailable(), name, (WebMvcTagsProvider)customTagsProvider.getIfAvailable(), contributorsProvider.orderedStream().toList());
        ServerHttpObservationFilter filter = new ServerHttpObservationFilter(registry, convention);
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registration.setOrder(-2147483647);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    private static ServerRequestObservationConvention createConvention(ServerRequestObservationConvention customConvention, String name, WebMvcTagsProvider tagsProvider, List<WebMvcTagsContributor> contributors) {
        if (customConvention != null) {
            return customConvention;
        }
        if (tagsProvider != null || contributors.size() > 0) {
            return new ServerRequestObservationConventionAdapter(name, tagsProvider, contributors);
        }
        return new DefaultServerRequestObservationConvention(name);
    }

    private static String httpRequestsMetricName(ObservationProperties observationProperties, MetricsProperties metricsProperties) {
        String observationName = observationProperties.getHttp().getServer().getRequests().getName();
        return observationName != null ? observationName : metricsProperties.getWeb().getServer().getRequest().getMetricName();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    static class MeterFilterConfiguration {
        MeterFilterConfiguration() {
        }

        @Bean
        @Order(value=0)
        MeterFilter metricsHttpServerUriTagFilter(MetricsProperties metricsProperties, ObservationProperties observationProperties) {
            String name = WebMvcObservationAutoConfiguration.httpRequestsMetricName(observationProperties, metricsProperties);
            OnlyOnceLoggingDenyMeterFilter filter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", name));
            return MeterFilter.maximumAllowableTags(name, "uri", metricsProperties.getWeb().getServer().getMaxUriTags(), filter);
        }
    }
}

