/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.task;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.autoconfigure.task.TaskSchedulingAutoConfiguration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@AutoConfiguration(after={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, TaskExecutionAutoConfiguration.class, TaskSchedulingAutoConfiguration.class})
@ConditionalOnClass(value={ExecutorServiceMetrics.class})
@ConditionalOnBean(value={Executor.class, MeterRegistry.class})
public class TaskExecutorMetricsAutoConfiguration {
    @Autowired
    public void bindTaskExecutorsToRegistry(Map<String, Executor> executors, MeterRegistry registry) {
        executors.forEach((beanName, executor) -> {
            if (executor instanceof ThreadPoolTaskExecutor) {
                ThreadPoolTaskExecutor threadPoolTaskExecutor = (ThreadPoolTaskExecutor)executor;
                this.monitor(registry, this.safeGetThreadPoolExecutor(threadPoolTaskExecutor), (String)beanName);
            } else if (executor instanceof ThreadPoolTaskScheduler) {
                ThreadPoolTaskScheduler threadPoolTaskScheduler = (ThreadPoolTaskScheduler)executor;
                this.monitor(registry, this.safeGetThreadPoolExecutor(threadPoolTaskScheduler), (String)beanName);
            }
        });
    }

    private void monitor(MeterRegistry registry, ThreadPoolExecutor threadPoolExecutor, String name) {
        if (threadPoolExecutor != null) {
            new ExecutorServiceMetrics(threadPoolExecutor, name, Collections.emptyList()).bindTo(registry);
        }
    }

    private ThreadPoolExecutor safeGetThreadPoolExecutor(ThreadPoolTaskExecutor taskExecutor) {
        try {
            return taskExecutor.getThreadPoolExecutor();
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    private ThreadPoolExecutor safeGetThreadPoolExecutor(ThreadPoolTaskScheduler taskScheduler) {
        try {
            return taskScheduler.getScheduledThreadPoolExecutor();
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }
}

