/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.jersey;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jersey.server.AnnotationFinder;
import io.micrometer.core.instrument.binder.jersey.server.DefaultJerseyTagsProvider;
import io.micrometer.core.instrument.binder.jersey.server.JerseyTagsProvider;
import io.micrometer.core.instrument.binder.jersey.server.MetricsApplicationEventListener;
import io.micrometer.core.instrument.config.MeterFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.OnlyOnceLoggingDenyMeterFilter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jersey.ResourceConfigCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;

@AutoConfiguration(after={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={ResourceConfig.class, MetricsApplicationEventListener.class})
@ConditionalOnBean(value={MeterRegistry.class, ResourceConfig.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class JerseyServerMetricsAutoConfiguration {
    private final MetricsProperties properties;

    public JerseyServerMetricsAutoConfiguration(MetricsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={JerseyTagsProvider.class})
    public DefaultJerseyTagsProvider jerseyTagsProvider() {
        return new DefaultJerseyTagsProvider();
    }

    @Bean
    public ResourceConfigCustomizer jerseyServerMetricsResourceConfigCustomizer(MeterRegistry meterRegistry, JerseyTagsProvider tagsProvider) {
        MetricsProperties.Web.Server server = this.properties.getWeb().getServer();
        return config -> config.register((Object)new MetricsApplicationEventListener(meterRegistry, tagsProvider, server.getRequest().getMetricName(), true, new AnnotationUtilsAnnotationFinder()));
    }

    @Bean
    @Order(value=0)
    public MeterFilter jerseyMetricsUriTagFilter() {
        String metricName = this.properties.getWeb().getServer().getRequest().getMetricName();
        OnlyOnceLoggingDenyMeterFilter filter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", metricName));
        return MeterFilter.maximumAllowableTags(metricName, "uri", this.properties.getWeb().getServer().getMaxUriTags(), filter);
    }

    private static class AnnotationUtilsAnnotationFinder
    implements AnnotationFinder {
        private AnnotationUtilsAnnotationFinder() {
        }

        @Override
        public <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
            return AnnotationUtils.findAnnotation(annotatedElement, annotationType);
        }
    }
}

