/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export;

import org.springframework.boot.actuate.autoconfigure.metrics.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnMetricsExportEnabledCondition
extends SpringBootCondition {
    private static final String PROPERTY_TEMPLATE = "management.%s.metrics.export.enabled";
    private static final String DEFAULT_PROPERTY_NAME = "management.defaults.metrics.export.enabled";

    OnMetricsExportEnabledCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap(metadata.getAnnotationAttributes(ConditionalOnEnabledMetricsExport.class.getName()));
        String endpointName = annotationAttributes.getString("value");
        ConditionOutcome outcome = this.getProductOutcome(context, endpointName);
        if (outcome != null) {
            return outcome;
        }
        return this.getDefaultOutcome(context);
    }

    private ConditionOutcome getProductOutcome(ConditionContext context, String productName) {
        Environment environment = context.getEnvironment();
        String enabledProperty = PROPERTY_TEMPLATE.formatted(productName);
        if (environment.containsProperty(enabledProperty)) {
            boolean match = environment.getProperty(enabledProperty, Boolean.class, true);
            return new ConditionOutcome(match, ConditionMessage.forCondition(ConditionalOnEnabledMetricsExport.class, new Object[0]).because(enabledProperty + " is " + match));
        }
        return null;
    }

    private ConditionOutcome getDefaultOutcome(ConditionContext context) {
        boolean match = Boolean.parseBoolean(context.getEnvironment().getProperty(DEFAULT_PROPERTY_NAME, "true"));
        return new ConditionOutcome(match, ConditionMessage.forCondition(ConditionalOnEnabledMetricsExport.class, new Object[0]).because("management.defaults.metrics.export.enabled is considered " + match));
    }
}

