/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import io.getunleash.FeatureToggle;
import io.getunleash.lang.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ToggleCollection {
    private final Collection<FeatureToggle> features;
    private final int version = 1;
    private final transient Map<String, FeatureToggle> cache;

    public ToggleCollection(Collection<FeatureToggle> features) {
        this.features = this.ensureNotNull(features);
        this.cache = new ConcurrentHashMap<String, FeatureToggle>();
        for (FeatureToggle featureToggle : this.features) {
            this.cache.put(featureToggle.getName(), featureToggle);
        }
    }

    private Collection<FeatureToggle> ensureNotNull(@Nullable Collection<FeatureToggle> features) {
        if (features == null) {
            return Collections.emptyList();
        }
        return features;
    }

    public Collection<FeatureToggle> getFeatures() {
        return Collections.unmodifiableCollection(this.features);
    }

    public FeatureToggle getToggle(String name) {
        return this.cache.get(name);
    }
}

