/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import com.google.gson.JsonSyntaxException;
import io.getunleash.UnleashException;
import io.getunleash.repository.ClientFeaturesResponse;
import io.getunleash.repository.FeatureCollection;
import io.getunleash.repository.FeatureFetcher;
import io.getunleash.repository.FeatureToggleResponse;
import io.getunleash.repository.JsonFeatureParser;
import io.getunleash.util.OkHttpClientConfigurer;
import io.getunleash.util.UnleashConfig;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import okhttp3.Cache;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpFeatureFetcher
implements FeatureFetcher {
    private final HttpUrl toggleUrl;
    private final OkHttpClient client;

    public OkHttpFeatureFetcher(UnleashConfig unleashConfig) {
        File tempDir = null;
        try {
            tempDir = Files.createTempDirectory("http_cache", new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(unleashConfig.getFetchTogglesConnectTimeout()).callTimeout(unleashConfig.getFetchTogglesReadTimeout()).followRedirects(true);
        if (tempDir != null) {
            builder = builder.cache(new Cache(tempDir, 0x3200000L));
        }
        if (unleashConfig.getProxy() != null) {
            builder = builder.proxy(unleashConfig.getProxy());
        }
        this.toggleUrl = Objects.requireNonNull(HttpUrl.get((URL)unleashConfig.getUnleashURLs().getFetchTogglesURL(unleashConfig.getProjectName(), unleashConfig.getNamePrefix())));
        this.client = OkHttpClientConfigurer.configureInterceptor(unleashConfig, builder.build());
    }

    public OkHttpFeatureFetcher(UnleashConfig unleashConfig, OkHttpClient client) {
        this.client = OkHttpClientConfigurer.configureInterceptor(unleashConfig, client);
        this.toggleUrl = Objects.requireNonNull(HttpUrl.get((URL)unleashConfig.getUnleashURLs().getFetchTogglesURL(unleashConfig.getProjectName(), unleashConfig.getNamePrefix())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClientFeaturesResponse fetchFeatures() throws UnleashException {
        Request request = new Request.Builder().url(this.toggleUrl).get().build();
        HttpUrl location = this.toggleUrl;
        int code = 200;
        try (Response response = this.client.newCall(request).execute();){
            if (response.isSuccessful()) {
                if (response.networkResponse() != null && response.networkResponse().code() == 304) {
                    ClientFeaturesResponse clientFeaturesResponse = new ClientFeaturesResponse(FeatureToggleResponse.Status.NOT_CHANGED, 304);
                    return clientFeaturesResponse;
                }
                location = response.request().url();
                code = response.code();
                FeatureCollection features = JsonFeatureParser.fromJson(Objects.requireNonNull(response.body()).charStream());
                ClientFeaturesResponse clientFeaturesResponse = new ClientFeaturesResponse(FeatureToggleResponse.Status.CHANGED, features.getToggleCollection(), features.getSegmentCollection());
                return clientFeaturesResponse;
            }
            if (response.code() == 304) {
                ClientFeaturesResponse clientFeaturesResponse = new ClientFeaturesResponse(FeatureToggleResponse.Status.NOT_CHANGED, response.code());
                return clientFeaturesResponse;
            }
            ClientFeaturesResponse clientFeaturesResponse = new ClientFeaturesResponse(FeatureToggleResponse.Status.UNAVAILABLE, response.code());
            return clientFeaturesResponse;
        }
        catch (IOException | NullPointerException ioEx) {
            throw new UnleashException("Could not fetch toggles", ioEx);
        }
        catch (JsonSyntaxException | IllegalStateException ex) {
            return new ClientFeaturesResponse(FeatureToggleResponse.Status.UNAVAILABLE, code, location.toString());
        }
    }
}

