/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.getunleash.FeatureToggle;
import io.getunleash.Segment;
import io.getunleash.lang.Nullable;
import io.getunleash.repository.FeatureCollection;
import io.getunleash.repository.SegmentCollection;
import io.getunleash.repository.ToggleCollection;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class JsonFeaturesDeserializer
implements JsonDeserializer<FeatureCollection> {
    private static final Type PARAMS_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type SEGMENT_COLLECTION_TYPE = new TypeToken<Collection<Segment>>(){}.getType();
    private static final Type TOGGLE_COLLECTION_TYPE = new TypeToken<Collection<FeatureToggle>>(){}.getType();

    @Override
    @Nullable
    public FeatureCollection deserialize(JsonElement rootElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        return JsonFeaturesDeserializer.deserializeVersion(rootElement, context);
    }

    @Nullable
    static FeatureCollection deserializeVersion(JsonElement rootElement, JsonDeserializationContext context) {
        if (!rootElement.getAsJsonObject().has("features")) {
            return null;
        }
        JsonObject root = rootElement.getAsJsonObject();
        JsonArray segmentArray = root.getAsJsonArray("segments");
        JsonArray togglesArray = root.getAsJsonArray("features");
        Collection toggles = (Collection)context.deserialize(togglesArray, TOGGLE_COLLECTION_TYPE);
        Collection segments = (Collection)context.deserialize(segmentArray, SEGMENT_COLLECTION_TYPE);
        return new FeatureCollection(new ToggleCollection(toggles), new SegmentCollection(segments));
    }
}

