/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import io.getunleash.FeatureToggle;
import io.getunleash.Segment;
import io.getunleash.UnleashException;
import io.getunleash.event.EventDispatcher;
import io.getunleash.event.UnleashReady;
import io.getunleash.lang.Nullable;
import io.getunleash.repository.BackupHandler;
import io.getunleash.repository.ClientFeaturesResponse;
import io.getunleash.repository.FeatureBackupHandlerFile;
import io.getunleash.repository.FeatureBootstrapHandler;
import io.getunleash.repository.FeatureCollection;
import io.getunleash.repository.FeatureFetcher;
import io.getunleash.repository.FeatureToggleResponse;
import io.getunleash.repository.IFeatureRepository;
import io.getunleash.repository.SegmentCollection;
import io.getunleash.util.UnleashConfig;
import io.getunleash.util.UnleashScheduledExecutor;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class FeatureRepository
implements IFeatureRepository {
    private final UnleashConfig unleashConfig;
    private final BackupHandler<FeatureCollection> featureBackupHandler;
    private final FeatureBootstrapHandler featureBootstrapHandler;
    private final FeatureFetcher featureFetcher;
    private final EventDispatcher eventDispatcher;
    private FeatureCollection featureCollection;
    private boolean ready;

    public FeatureRepository(UnleashConfig unleashConfig) {
        this(unleashConfig, new FeatureBackupHandlerFile(unleashConfig));
    }

    public FeatureRepository(UnleashConfig unleashConfig, BackupHandler<FeatureCollection> featureBackupHandler) {
        this.unleashConfig = unleashConfig;
        this.featureBackupHandler = featureBackupHandler;
        this.featureFetcher = (FeatureFetcher)unleashConfig.getUnleashFeatureFetcherFactory().apply(unleashConfig);
        this.featureBootstrapHandler = new FeatureBootstrapHandler(unleashConfig);
        this.eventDispatcher = new EventDispatcher(unleashConfig);
        this.initCollections(unleashConfig.getScheduledExecutor());
    }

    protected FeatureRepository(UnleashConfig unleashConfig, BackupHandler<FeatureCollection> featureBackupHandler, EventDispatcher eventDispatcher, FeatureFetcher featureFetcher, FeatureBootstrapHandler featureBootstrapHandler) {
        this.unleashConfig = unleashConfig;
        this.featureBackupHandler = featureBackupHandler;
        this.featureFetcher = featureFetcher;
        this.featureBootstrapHandler = featureBootstrapHandler;
        this.eventDispatcher = eventDispatcher;
        this.initCollections(unleashConfig.getScheduledExecutor());
    }

    protected FeatureRepository(UnleashConfig unleashConfig, FeatureBackupHandlerFile featureBackupHandler, UnleashScheduledExecutor executor, FeatureFetcher featureFetcher, FeatureBootstrapHandler featureBootstrapHandler) {
        this.unleashConfig = unleashConfig;
        this.featureBackupHandler = featureBackupHandler;
        this.featureFetcher = featureFetcher;
        this.featureBootstrapHandler = featureBootstrapHandler;
        this.eventDispatcher = new EventDispatcher(unleashConfig);
        this.initCollections(executor);
    }

    private void initCollections(UnleashScheduledExecutor executor) {
        this.featureCollection = this.featureBackupHandler.read();
        if (this.featureCollection.getToggleCollection().getFeatures().isEmpty()) {
            this.featureCollection = this.featureBootstrapHandler.read();
        }
        if (this.unleashConfig.isSynchronousFetchOnInitialisation()) {
            this.updateFeatures().run();
        }
        if (!this.unleashConfig.isDisablePolling()) {
            if (this.unleashConfig.getFetchTogglesInterval() > 0L) {
                executor.setInterval(this.updateFeatures(), 0L, this.unleashConfig.getFetchTogglesInterval());
            } else {
                executor.scheduleOnce(this.updateFeatures());
            }
        }
    }

    private Runnable updateFeatures() {
        return () -> {
            try {
                ClientFeaturesResponse response = this.featureFetcher.fetchFeatures();
                this.eventDispatcher.dispatch(response);
                if (response.getStatus() == FeatureToggleResponse.Status.CHANGED) {
                    SegmentCollection segmentCollection = response.getSegmentCollection();
                    this.featureCollection = new FeatureCollection(response.getToggleCollection(), segmentCollection != null ? segmentCollection : new SegmentCollection(Collections.emptyList()));
                    this.featureBackupHandler.write(this.featureCollection);
                }
                if (!this.ready) {
                    this.eventDispatcher.dispatch(new UnleashReady());
                    this.ready = true;
                }
            }
            catch (UnleashException e) {
                this.eventDispatcher.dispatch(e);
            }
        };
    }

    @Override
    @Nullable
    public FeatureToggle getToggle(String name) {
        return this.featureCollection.getToggleCollection().getToggle(name);
    }

    @Override
    public List<String> getFeatureNames() {
        return this.featureCollection.getToggleCollection().getFeatures().stream().map(FeatureToggle::getName).collect(Collectors.toList());
    }

    @Override
    public Segment getSegment(Integer id) {
        return this.featureCollection.getSegmentCollection().getSegment(id);
    }
}

