/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash;

import io.getunleash.EvaluatedToggle;
import io.getunleash.FeatureToggle;
import io.getunleash.MoreOperations;
import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import io.getunleash.UnleashContextProvider;
import io.getunleash.Variant;
import io.getunleash.event.EventDispatcher;
import io.getunleash.event.ToggleEvaluated;
import io.getunleash.lang.Nullable;
import io.getunleash.metric.UnleashMetricService;
import io.getunleash.metric.UnleashMetricServiceImpl;
import io.getunleash.repository.FeatureRepository;
import io.getunleash.repository.IFeatureRepository;
import io.getunleash.strategy.ApplicationHostnameStrategy;
import io.getunleash.strategy.DefaultStrategy;
import io.getunleash.strategy.FlexibleRolloutStrategy;
import io.getunleash.strategy.GradualRolloutRandomStrategy;
import io.getunleash.strategy.GradualRolloutSessionIdStrategy;
import io.getunleash.strategy.GradualRolloutUserIdStrategy;
import io.getunleash.strategy.RemoteAddressStrategy;
import io.getunleash.strategy.Strategy;
import io.getunleash.strategy.UnknownStrategy;
import io.getunleash.strategy.UserWithIdStrategy;
import io.getunleash.util.ConstraintMerger;
import io.getunleash.util.UnleashConfig;
import io.getunleash.variant.VariantUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnleash
implements Unleash {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUnleash.class);
    private static ConcurrentHashMap<String, LongAdder> initCounts = new ConcurrentHashMap();
    private static final List<Strategy> BUILTIN_STRATEGIES = Arrays.asList(new DefaultStrategy(), new ApplicationHostnameStrategy(), new GradualRolloutRandomStrategy(), new GradualRolloutSessionIdStrategy(), new GradualRolloutUserIdStrategy(), new RemoteAddressStrategy(), new UserWithIdStrategy(), new FlexibleRolloutStrategy());
    public static final UnknownStrategy UNKNOWN_STRATEGY = new UnknownStrategy();
    private final UnleashMetricService metricService;
    private final IFeatureRepository featureRepository;
    private final Map<String, Strategy> strategyMap;
    private final UnleashContextProvider contextProvider;
    private final EventDispatcher eventDispatcher;
    private final UnleashConfig config;

    private static IFeatureRepository defaultToggleRepository(UnleashConfig unleashConfig) {
        return new FeatureRepository(unleashConfig);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, Strategy ... strategies) {
        this(unleashConfig, DefaultUnleash.defaultToggleRepository(unleashConfig), strategies);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, IFeatureRepository featureRepository, Strategy ... strategies) {
        this(unleashConfig, featureRepository, DefaultUnleash.buildStrategyMap(strategies), unleashConfig.getContextProvider(), new EventDispatcher(unleashConfig), new UnleashMetricServiceImpl(unleashConfig, unleashConfig.getScheduledExecutor()), false);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, IFeatureRepository featureRepository, Map<String, Strategy> strategyMap, UnleashContextProvider contextProvider, EventDispatcher eventDispatcher, UnleashMetricService metricService) {
        this(unleashConfig, featureRepository, strategyMap, contextProvider, eventDispatcher, metricService, false);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, IFeatureRepository featureRepository, Map<String, Strategy> strategyMap, UnleashContextProvider contextProvider, EventDispatcher eventDispatcher, UnleashMetricService metricService, boolean failOnMultipleInstantiations) {
        this.config = unleashConfig;
        this.featureRepository = featureRepository;
        this.strategyMap = strategyMap;
        this.contextProvider = contextProvider;
        this.eventDispatcher = eventDispatcher;
        this.metricService = metricService;
        metricService.register(strategyMap.keySet());
        initCounts.compute(this.config.getClientIdentifier(), (key, inits) -> {
            if (inits != null) {
                String error = String.format("You already have %d clients for Unleash Configuration [%s] running. Please double check your code where you are instantiating the Unleash SDK", inits.sum(), key);
                if (failOnMultipleInstantiations) {
                    throw new RuntimeException(error);
                }
                LOGGER.error(error);
            }
            LongAdder a = inits == null ? new LongAdder() : inits;
            a.increment();
            return a;
        });
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, BiPredicate<String, UnleashContext> fallbackAction) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), fallbackAction);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction) {
        boolean enabled = this.checkEnabled(toggleName, context, fallbackAction);
        this.count(toggleName, enabled);
        this.eventDispatcher.dispatch(new ToggleEvaluated(toggleName, enabled));
        return enabled;
    }

    private boolean checkEnabled(String toggleName, UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction) {
        boolean enabled;
        this.checkIfToggleMatchesNamePrefix(toggleName);
        FeatureToggle featureToggle = this.featureRepository.getToggle(toggleName);
        UnleashContext enhancedContext = context.applyStaticFields(this.config);
        if (featureToggle == null) {
            enabled = fallbackAction.test(toggleName, enhancedContext);
        } else if (!featureToggle.isEnabled()) {
            enabled = false;
        } else {
            if (featureToggle.getStrategies().size() == 0) {
                return true;
            }
            enabled = featureToggle.getStrategies().stream().anyMatch(strategy -> {
                Strategy configuredStrategy = this.getStrategy(strategy.getName());
                if (configuredStrategy == UNKNOWN_STRATEGY) {
                    LOGGER.warn("Unable to find matching strategy for toggle:{} strategy:{}", (Object)toggleName, (Object)strategy.getName());
                }
                return configuredStrategy.isEnabled(strategy.getParameters(), enhancedContext, ConstraintMerger.mergeConstraints(this.featureRepository, strategy));
            });
        }
        return enabled;
    }

    private void checkIfToggleMatchesNamePrefix(String toggleName) {
        if (this.config.getNamePrefix() != null && !toggleName.startsWith(this.config.getNamePrefix())) {
            LOGGER.warn("Toggle [{}] doesnt start with configured name prefix of [{}] so it will always be disabled", (Object)toggleName, (Object)this.config.getNamePrefix());
        }
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context) {
        return this.getVariant(toggleName, context, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        FeatureToggle featureToggle = this.featureRepository.getToggle(toggleName);
        boolean enabled = this.checkEnabled(toggleName, context, (n, c) -> false);
        Variant variant = enabled ? VariantUtil.selectVariant(featureToggle, context, defaultValue) : defaultValue;
        this.metricService.countVariant(toggleName, variant.getName());
        this.metricService.count(toggleName, enabled);
        return variant;
    }

    @Override
    public Variant getVariant(String toggleName) {
        return this.getVariant(toggleName, this.contextProvider.getContext());
    }

    @Override
    public Variant getVariant(String toggleName, Variant defaultValue) {
        return this.getVariant(toggleName, this.contextProvider.getContext(), defaultValue);
    }

    @Deprecated
    public Optional<FeatureToggle> getFeatureToggleDefinition(String toggleName) {
        return Optional.ofNullable(this.featureRepository.getToggle(toggleName));
    }

    @Override
    @Deprecated
    public List<String> getFeatureToggleNames() {
        return this.featureRepository.getFeatureNames();
    }

    @Deprecated
    public void count(String toggleName, boolean enabled) {
        this.metricService.count(toggleName, enabled);
    }

    private static Map<String, Strategy> buildStrategyMap(@Nullable Strategy[] strategies) {
        HashMap<String, Strategy> map = new HashMap<String, Strategy>();
        BUILTIN_STRATEGIES.forEach(strategy -> map.put(strategy.getName(), (Strategy)strategy));
        if (strategies != null) {
            for (Strategy strategy2 : strategies) {
                map.put(strategy2.getName(), strategy2);
            }
        }
        return map;
    }

    private Strategy getStrategy(String strategy) {
        return this.strategyMap.getOrDefault(strategy, this.config.getFallbackStrategy());
    }

    @Override
    public void shutdown() {
        this.config.getScheduledExecutor().shutdown();
    }

    @Override
    public MoreOperations more() {
        return new DefaultMore();
    }

    public class DefaultMore
    implements MoreOperations {
        @Override
        public List<String> getFeatureToggleNames() {
            return DefaultUnleash.this.featureRepository.getFeatureNames();
        }

        @Override
        public Optional<FeatureToggle> getFeatureToggleDefinition(String toggleName) {
            return Optional.ofNullable(DefaultUnleash.this.featureRepository.getToggle(toggleName));
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles() {
            return this.evaluateAllToggles(DefaultUnleash.this.contextProvider.getContext());
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles(UnleashContext context) {
            return this.getFeatureToggleNames().stream().map(toggleName -> {
                boolean enabled = DefaultUnleash.this.checkEnabled(toggleName, context, (n, c) -> false);
                FeatureToggle featureToggle = DefaultUnleash.this.featureRepository.getToggle((String)toggleName);
                Variant variant = enabled ? VariantUtil.selectVariant(featureToggle, context, Variant.DISABLED_VARIANT) : Variant.DISABLED_VARIANT;
                return new EvaluatedToggle((String)toggleName, enabled, variant);
            }).collect(Collectors.toList());
        }

        @Override
        public void count(String toggleName, boolean enabled) {
            DefaultUnleash.this.metricService.count(toggleName, enabled);
        }

        @Override
        public void countVariant(String toggleName, String variantName) {
            DefaultUnleash.this.metricService.countVariant(toggleName, variantName);
        }
    }
}

