/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.reactive;

import java.lang.reflect.Modifier;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextFactory;
import org.springframework.boot.autoconfigure.web.reactive.ReactiveWebServerFactoryAutoConfiguration;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.reactive.context.AnnotationConfigReactiveWebServerApplicationContext;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

class ReactiveManagementContextFactory
implements ManagementContextFactory {
    ReactiveManagementContextFactory() {
    }

    @Override
    public ConfigurableWebServerApplicationContext createManagementContext(ApplicationContext parent, Class<?> ... configClasses) {
        Environment parentEnvironment = parent.getEnvironment();
        ConfigurableEnvironment childEnvironment = ApplicationContextFactory.DEFAULT.createEnvironment(WebApplicationType.REACTIVE);
        if (parentEnvironment instanceof ConfigurableEnvironment) {
            childEnvironment.setConversionService(((ConfigurableEnvironment)parentEnvironment).getConversionService());
        }
        AnnotationConfigReactiveWebServerApplicationContext child = new AnnotationConfigReactiveWebServerApplicationContext();
        child.setEnvironment(childEnvironment);
        child.setParent(parent);
        Class[] combinedClasses = ObjectUtils.addObjectToArray(configClasses, ReactiveWebServerFactoryAutoConfiguration.class);
        child.register(combinedClasses);
        this.registerReactiveWebServerFactory(parent, child);
        return child;
    }

    private void registerReactiveWebServerFactory(ApplicationContext parent, AnnotationConfigReactiveWebServerApplicationContext childContext) {
        try {
            ConfigurableListableBeanFactory beanFactory = childContext.getBeanFactory();
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                registry.registerBeanDefinition("ReactiveWebServerFactory", (BeanDefinition)new RootBeanDefinition(this.determineReactiveWebServerFactoryClass(parent)));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private Class<?> determineReactiveWebServerFactoryClass(ApplicationContext parent) throws NoSuchBeanDefinitionException {
        Class<?> factoryClass = ((ReactiveWebServerFactory)parent.getBean(ReactiveWebServerFactory.class)).getClass();
        if (this.cannotBeInstantiated(factoryClass)) {
            throw new FatalBeanException("ReactiveWebServerFactory implementation " + factoryClass.getName() + " cannot be instantiated. To allow a separate management port to be used, a top-level class or static inner class should be used instead");
        }
        return factoryClass;
    }

    private boolean cannotBeInstantiated(Class<?> factoryClass) {
        return factoryClass.isLocalClass() || factoryClass.isMemberClass() && !Modifier.isStatic(factoryClass.getModifiers()) || factoryClass.isAnonymousClass();
    }
}

