/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.logging;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.logging.LogFileWebEndpointProperties;
import org.springframework.boot.actuate.logging.LogFileWebEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.logging.LogFile;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnAvailableEndpoint(endpoint=LogFileWebEndpoint.class)
@EnableConfigurationProperties(value={LogFileWebEndpointProperties.class})
public class LogFileWebEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={LogFileCondition.class})
    public LogFileWebEndpoint logFileWebEndpoint(ObjectProvider<LogFile> logFile, LogFileWebEndpointProperties properties) {
        return new LogFileWebEndpoint((LogFile)logFile.getIfAvailable(), properties.getExternalFile());
    }

    private static class LogFileCondition
    extends SpringBootCondition {
        private LogFileCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            String config = this.getLogFileConfig(environment, "logging.file.name");
            ConditionMessage.Builder message = ConditionMessage.forCondition("Log File", new Object[0]);
            if (StringUtils.hasText(config)) {
                return ConditionOutcome.match(message.found("logging.file.name").items(config));
            }
            config = this.getLogFileConfig(environment, "logging.file.path");
            if (StringUtils.hasText(config)) {
                return ConditionOutcome.match(message.found("logging.file.path").items(config));
            }
            config = environment.getProperty("management.endpoint.logfile.external-file");
            if (StringUtils.hasText(config)) {
                return ConditionOutcome.match(message.found("management.endpoint.logfile.external-file").items(config));
            }
            return ConditionOutcome.noMatch(message.didNotFind("logging file").atAll());
        }

        private String getLogFileConfig(Environment environment, String configName) {
            return environment.resolvePlaceholders("${" + configName + ":}");
        }
    }
}

