/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.mockito.plugins.MockResolver;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;

public class SpringBootMockResolver
implements MockResolver {
    public Object resolve(Object instance) {
        return SpringBootMockResolver.getUltimateTargetObject(instance);
    }

    private static <T> T getUltimateTargetObject(Object candidate) {
        Assert.notNull(candidate, "Candidate must not be null");
        try {
            Object target;
            Advised advised;
            TargetSource targetSource;
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised && (targetSource = (advised = (Advised)candidate).getTargetSource()).isStatic() && (target = targetSource.getTarget()) != null) {
                return SpringBootMockResolver.getUltimateTargetObject(target);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }
}

