/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;

class DuplicateJsonObjectContextCustomizerFactory
implements ContextCustomizerFactory {
    DuplicateJsonObjectContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        return new DuplicateJsonObjectContextCustomizer();
    }

    private static class DuplicateJsonObjectContextCustomizer
    implements ContextCustomizer {
        private final Log logger = LogFactory.getLog(DuplicateJsonObjectContextCustomizer.class);

        private DuplicateJsonObjectContextCustomizer() {
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            List<URL> jsonObjects = this.findJsonObjects();
            if (jsonObjects.size() > 1) {
                this.logDuplicateJsonObjectsWarning(jsonObjects);
            }
        }

        private List<URL> findJsonObjects() {
            try {
                Enumeration<URL> resources = this.getClass().getClassLoader().getResources("org/json/JSONObject.class");
                return Collections.list(resources);
            }
            catch (Exception exception) {
                return Collections.emptyList();
            }
        }

        private void logDuplicateJsonObjectsWarning(List<URL> jsonObjects) {
            StringBuilder message = new StringBuilder(String.format("%n%nFound multiple occurrences of org.json.JSONObject on the class path:%n%n", new Object[0]));
            for (URL jsonObject : jsonObjects) {
                message.append(String.format("\t%s%n", jsonObject));
            }
            message.append(String.format("%nYou may wish to exclude one of them to ensure predictable runtime behavior%n", new Object[0]));
            this.logger.warn(message);
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

