/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.web.client;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.metrics.web.client.DefaultRestTemplateExchangeTagsProvider;
import org.springframework.boot.actuate.metrics.web.client.MetricsRestTemplateCustomizer;
import org.springframework.boot.actuate.metrics.web.client.RestTemplateExchangeTagsProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnBean(value={RestTemplateBuilder.class})
class RestTemplateMetricsConfiguration {
    RestTemplateMetricsConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={RestTemplateExchangeTagsProvider.class})
    DefaultRestTemplateExchangeTagsProvider restTemplateExchangeTagsProvider() {
        return new DefaultRestTemplateExchangeTagsProvider();
    }

    @Bean
    MetricsRestTemplateCustomizer metricsRestTemplateCustomizer(MeterRegistry meterRegistry, RestTemplateExchangeTagsProvider restTemplateExchangeTagsProvider, MetricsProperties properties) {
        MetricsProperties.Web.Client.ClientRequest request = properties.getWeb().getClient().getRequest();
        return new MetricsRestTemplateCustomizer(meterRegistry, restTemplateExchangeTagsProvider, request.getMetricName(), request.getAutotime());
    }
}

