/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collection;
import java.util.Map;
import org.springframework.boot.actuate.health.DefaultHealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.util.Assert;

class AutoConfiguredHealthContributorRegistry
extends DefaultHealthContributorRegistry {
    private final Collection<String> groupNames;

    AutoConfiguredHealthContributorRegistry(Map<String, HealthContributor> contributors, Collection<String> groupNames) {
        super(contributors);
        this.groupNames = groupNames;
        contributors.keySet().forEach(this::assertDoesNotClashWithGroup);
    }

    @Override
    public void registerContributor(String name, HealthContributor contributor) {
        this.assertDoesNotClashWithGroup(name);
        super.registerContributor(name, contributor);
    }

    private void assertDoesNotClashWithGroup(String name) {
        Assert.state(!this.groupNames.contains(name), () -> "HealthContributor with name \"" + name + "\" clashes with group");
    }
}

