/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.sql.init;

import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.sql.init.SettingsCreator;
import org.springframework.boot.autoconfigure.sql.init.SqlInitializationProperties;
import org.springframework.boot.r2dbc.ConnectionFactoryBuilder;
import org.springframework.boot.r2dbc.init.R2dbcScriptDatabaseInitializer;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.r2dbc.connection.init.DatabasePopulator;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ConnectionFactory.class, DatabasePopulator.class})
@ConditionalOnSingleCandidate(value=ConnectionFactory.class)
class R2dbcInitializationConfiguration {
    R2dbcInitializationConfiguration() {
    }

    @Bean
    R2dbcScriptDatabaseInitializer r2dbcScriptDatabaseInitializer(ConnectionFactory connectionFactory, SqlInitializationProperties properties) {
        DatabaseInitializationSettings settings = SettingsCreator.createFrom(properties);
        return new R2dbcScriptDatabaseInitializer(R2dbcInitializationConfiguration.determineConnectionFactory(connectionFactory, properties.getUsername(), properties.getPassword()), settings);
    }

    private static ConnectionFactory determineConnectionFactory(ConnectionFactory connectionFactory, String username, String password) {
        if (StringUtils.hasText(username) && StringUtils.hasText(password)) {
            return ConnectionFactoryBuilder.derivedFrom((ConnectionFactory)connectionFactory).username(username).password((CharSequence)password).build();
        }
        return connectionFactory;
    }
}

