/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import no.finn.unleash.lang.Nullable;

public class UnleashURLs {
    private final URL fetchTogglesURL;
    private final URL clientMetricsURL;
    private final URL clientRegisterURL;

    public UnleashURLs(URI unleashAPI) {
        try {
            String unleashAPIstr = unleashAPI.toString();
            this.fetchTogglesURL = URI.create(unleashAPIstr + "/client/features").normalize().toURL();
            this.clientMetricsURL = URI.create(unleashAPIstr + "/client/metrics").normalize().toURL();
            this.clientRegisterURL = URI.create(unleashAPIstr + "/client/register").normalize().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Unleash API is not a valid URL: " + unleashAPI);
        }
    }

    public URL getFetchTogglesURL() {
        return this.fetchTogglesURL;
    }

    public URL getClientMetricsURL() {
        return this.clientMetricsURL;
    }

    public URL getClientRegisterURL() {
        return this.clientRegisterURL;
    }

    public URL getFetchTogglesURL(@Nullable String projectName, @Nullable String namePrefix) {
        StringBuilder suffix = new StringBuilder("");
        this.appendParam(suffix, "project", projectName);
        this.appendParam(suffix, "namePrefix", namePrefix);
        try {
            return URI.create(this.fetchTogglesURL + suffix.toString()).normalize().toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new IllegalArgumentException("fetchTogglesURL [" + this.fetchTogglesURL + suffix + "] was not URL friendly.", e);
        }
    }

    private void appendParam(StringBuilder suffix, String key, @Nullable String value) {
        if (value == null) {
            return;
        }
        if (suffix.length() == 0) {
            suffix.append("?");
        } else {
            suffix.append("&");
        }
        suffix.append(key).append("=").append(value);
    }
}

