/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.strategy;

import com.sangupta.murmur.Murmur3;
import no.finn.unleash.lang.Nullable;

public final class StrategyUtils {
    private static final int ONE_HUNDRED = 100;

    public static boolean isNotEmpty(CharSequence cs) {
        return !StrategyUtils.isEmpty(cs);
    }

    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StrategyUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int getNormalizedNumber(String identifier, String groupId) {
        return StrategyUtils.getNormalizedNumber(identifier, groupId, 100);
    }

    public static int getNormalizedNumber(String identifier, String groupId, int normalizer) {
        byte[] value = (groupId + ':' + identifier).getBytes();
        long hash = Murmur3.hash_x86_32(value, value.length, 0L);
        return (int)(hash % (long)normalizer) + 1;
    }

    public static int getPercentage(String percentage) {
        if (StrategyUtils.isNotEmpty(percentage) && StrategyUtils.isNumeric(percentage)) {
            int p = Integer.parseInt(percentage);
            return p;
        }
        return 0;
    }
}

