/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import java.io.StringReader;
import java.util.Collections;
import no.finn.unleash.UnleashException;
import no.finn.unleash.event.EventDispatcher;
import no.finn.unleash.event.UnleashEvent;
import no.finn.unleash.event.UnleashSubscriber;
import no.finn.unleash.lang.Nullable;
import no.finn.unleash.repository.JsonToggleParser;
import no.finn.unleash.repository.ToggleBootstrapFileProvider;
import no.finn.unleash.repository.ToggleBootstrapProvider;
import no.finn.unleash.repository.ToggleCollection;
import no.finn.unleash.util.UnleashConfig;

public class ToggleBootstrapHandler {
    private final EventDispatcher eventDispatcher;
    private final ToggleBootstrapProvider toggleBootstrapProvider;

    public ToggleBootstrapHandler(UnleashConfig unleashConfig) {
        this.toggleBootstrapProvider = unleashConfig.getToggleBootstrapProvider() != null ? unleashConfig.getToggleBootstrapProvider() : new ToggleBootstrapFileProvider();
        this.eventDispatcher = new EventDispatcher(unleashConfig);
    }

    public ToggleCollection parse(@Nullable String jsonString) {
        if (jsonString != null) {
            StringReader stringReader = new StringReader(jsonString);
            try {
                ToggleCollection toggleCollection = JsonToggleParser.fromJson(stringReader);
                this.eventDispatcher.dispatch(new ToggleBootstrapRead(toggleCollection));
                ToggleCollection toggleCollection2 = toggleCollection;
                stringReader.close();
                return toggleCollection2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stringReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IllegalStateException ise) {
                    this.eventDispatcher.dispatch(new UnleashException("Failed to read toggle bootstrap", ise));
                }
            }
        }
        return new ToggleCollection(Collections.emptyList());
    }

    public ToggleCollection read() {
        if (this.toggleBootstrapProvider != null) {
            return this.parse(this.toggleBootstrapProvider.read());
        }
        return new ToggleCollection(Collections.emptyList());
    }

    public static class ToggleBootstrapRead
    implements UnleashEvent {
        private final ToggleCollection toggleCollection;

        private ToggleBootstrapRead(ToggleCollection toggleCollection) {
            this.toggleCollection = toggleCollection;
        }

        @Override
        public void publishTo(UnleashSubscriber unleashSubscriber) {
            unleashSubscriber.togglesBootstrapped(this.toggleCollection);
        }
    }
}

